% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cache.R
\name{hockeystick_cache}
\alias{hockeystick_cache}
\alias{hockeystick_cache_list}
\alias{hockeystick_cache_delete}
\alias{hockeystick_cache_delete_all}
\alias{hockeystick_cache_details}
\alias{hockeystick_update_all}
\title{Manage cached datasets}
\usage{
hockeystick_cache_list()

hockeystick_cache_delete(files, force = TRUE)

hockeystick_cache_delete_all(force = TRUE)

hockeystick_cache_details(files = NULL)

hockeystick_update_all()
}
\arguments{
\item{files}{(character) one or more complete file names}

\item{force}{(logical) Should files be force deleted? Default: \code{TRUE}}
}
\value{
\code{hockeystick_cache_list()} returns a character vector of full path filenames in cache.

\code{hockeystick_cache_delete()} no return value, called for side effect.

\code{hockeystick_cache_delete_all()} no return value, called for side effect.

\code{hockeystick_cache_details()} returns list of filenames and sizes of cached files.

\code{hockeystick_update_all()} updates all datasets. No return value, called for side effect.
}
\description{
Manage cached datasets
}
\details{
\code{cache_delete} only accepts 1 file name, while \code{cache_delete_all}
doesn't accept any names, but deletes all files. For deleting many
specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}} type call

We cache using \code{\link[rappdirs:user_cache_dir]{rappdirs::user_cache_dir()}}, find your cache
folder by executing \code{rappdirs::user_cache_dir("hockeystick")}
}
\section{Functions}{

\itemize{
\item \code{hockeystick_cache_list()} returns a character vector of full path
file names in cache
\item \code{hockeystick_cache_delete()} deletes one or more files, returns nothing
\item \code{hockeystick_cache_delete_all()} delete all files, returns nothing
\item \code{hockeystick_cache_details()} prints file name and file size of each file, supply with one or more files, or no files (and get details for all available)
\item \code{hockeystick_update_all()} updates the cache with the latest co2, temperature, sea level, and sea ice data.
}
}

\examples{
\donttest{
# list files in cache
hockeystick_cache_list()

# List info for single files
hockeystick_cache_details(files = hockeystick_cache_list()[1])
hockeystick_cache_details(files = hockeystick_cache_list()[2])

# List info for all files
hockeystick_cache_details()

# Delete files by name in cache
hockeystick_cache_delete(files = hockeystick_cache_list()[1])

# Delete all files in cache
hockeystick_cache_delete_all()

# Update all cached data
hockeystick_update_all()
}
}
\references{
Caching data sets: ROpenSci guide to persistent config and data for R packages: https://blog.r-hub.io/2020/03/12/user-preferences/
}
