% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_rstar_glm.R
\name{run_sim_rstar_glm}
\alias{run_sim_rstar_glm}
\title{Run Multiple Iterations of Simulation and Summarize Results}
\usage{
run_sim_rstar_glm(
  n_sims,
  alpha_level = 0.05,
  n_main,
  n_covariates,
  true_coef_main,
  n_control = NULL,
  true_coef_control = NULL,
  treatment_effect = NULL,
  model = c("logistic", "linear", "poisson"),
  skewness_main = NULL,
  skewness_control = NULL,
  Sigma_main = NULL,
  Sigma_control = NULL,
  ...
)
}
\arguments{
\item{n_sims}{Number of simulations to run.}

\item{alpha_level}{Significance level for hypothesis tests.}

\item{n_main}{Number of observations in the main group.}

\item{n_covariates}{Number of covariates.}

\item{true_coef_main}{True coefficients for the main group.}

\item{n_control}{Number of observations in the control group.}

\item{true_coef_control}{True coefficients for the control group.}

\item{treatment_effect}{Treatment effect size.}

\item{model}{Type of model: "logistic", "linear", or "poisson".}

\item{skewness_main}{Skewness for the main group covariates.}

\item{skewness_control}{Skewness for the control group covariates.}

\item{Sigma_main}{Covariance matrix for the main group covariates.}

\item{Sigma_control}{Covariance matrix for the control group covariates.}

\item{...}{Additional arguments passed to \code{sim_rstar_glm}.}
}
\value{
A list with the results of each simulation and a summary of the results.
}
\description{
This function runs multiple iterations of simulation for the \code{sim_rstar_glm}
function and summarizes the results, including rejection rates, bias, empirical
standard error, mean squared error, and root mean squared error.
}
\examples{
sim_summary <- run_sim_rstar_glm(
  n_sims = 2, alpha_level = 0.05,
  n_main = 100, n_covariates = 2, true_coef_main = c(0.5, -0.3),
  n_control = 100, true_coef_control = c(0.2, -0.1),
  treatment_effect = 1, model = "linear"
) |> suppressWarnings()

}
\references{
Pierce, D. A., & Bellio, R. (2017). Modern Likelihood-Frequentist Inference.
International Statistical Review / Revue Internationale de Statistique, 85(3),
519–541. \url{doi:10.1111/insr.12232}

Bellio R, Pierce D (2020). likelihoodAsy: Functions for Likelihood Asymptotics.
R package version 0.51, \url{https://CRAN.R-project.org/package=likelihoodAsy}.
}
