% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multvar.R
\name{sim_covar}
\alias{sim_covar}
\title{Simulate co-varying variables}
\usage{
sim_covar(.data = NULL, n_obs = NULL, n_vars, var, cov, name = NA,
  seed = NA)
}
\arguments{
\item{.data}{An optional dataframe.  If a dataframe is supplied, simulated categorical data will be added to the dataframe. Either `.data` or `n_obs` must be supplied.}

\item{n_obs}{Total number of observations/rows to simulate if `.data` is not supplied.}

\item{n_vars}{Number of variables to simulate.}

\item{var}{Variance used to construct variance-covariance matrix.}

\item{cov}{Covariance used to construct variance-covariance matrix.}

\item{name}{An optional name to be appended to the column names in the output.}

\item{seed}{An optional seed for random number generation.  If `NA` (default) a random seed will be used.}
}
\value{
a tibble
}
\description{
Adds a group of variables (columns) with a given variance and covariance to a data frame or tibble
}
\examples{
library(dplyr)
sim_cat(n_obs = 30, n_groups = 3) \%>\%
sim_covar(n_vars = 5, var = 1, cov = 0.5, name = "correlated")
}
\seealso{
\code{\link{sim_cat}}, \code{\link{sim_discr}}

Other multivariate normal functions: \code{\link{sim_cat}},
  \code{\link{sim_discr}}
}
\concept{multivariate normal functions}
