% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{howlerVolumeSlider}
\alias{howlerVolumeSlider}
\title{Volume Slider}
\usage{
howlerVolumeSlider(id, volume = 1, button = TRUE)
}
\arguments{
\item{id}{ID given to the volume slider. For it to work with the \code{\link{howler}}, the ID
must match that of the \code{howler}.}

\item{volume}{Initial volume to set the player at. Defaults at 100\%}

\item{button}{Logical, should a mute toggle button be included next to the slider? Default is \code{TRUE}}
}
\value{
A volume slider with a \code{\link{howlerVolumeDownButton}} and a \code{\link{howlerVolumeUpButton}} either side.
}
\description{
A more user friendly way to adjust the volume of the \code{howler} than by using buttons. There are
still volume up/down buttons, but a slider can be moved up/down as required.
}
\details{
If using \code{howlerVolumeSlider}, avoid using the volume buttons, as this will cause duplicate IDs to appear in the
shiny application and prevents the slider from working properly.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    howler(elementId = "sound", "audio/sound.mp3"),
    howlerPlayPauseButton("sound"),
    howlerVolumeSlider("sound")
  )

  server <- function(input, output, session) {
  }

  shinyApp(ui, server)
}

}
