% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{posterior_summary}
\alias{posterior_summary}
\alias{posterior_summary.default}
\alias{posterior_summary.hsstan}
\title{Posterior summary}
\usage{
posterior_summary(x, prob, ...)

\method{posterior_summary}{default}(x, prob = 0.95, ...)

\method{posterior_summary}{hsstan}(x, prob = 0.95, pars = NULL, ...)
}
\arguments{
\item{x}{An object containing or representing posterior samples. If \code{x}
is a matrix, it should have size \code{S} by \code{Q}, where \code{S}
is the number of posterior samples, and \code{Q} is the number of
quantities of interest.}

\item{prob}{Width of the posterior intervals (0.95, by default).}

\item{...}{Further arguments passed to or from other methods.}

\item{pars}{Vector of parameter names to be extracted. If \code{NULL}
(default) then this refers to the set of predictors used in the
model.}
}
\value{
A matrix with columns containing mean, standard deviation and posterior
intervals for the given quantities.
}
\description{
Produce a summary of the posterior samples for the quantities of interest.
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
posterior_summary(hs.biom)

}
\seealso{
\code{\link[=summary]{summary()}} to produce summaries of \code{hsstan} objects that include the number
of effective samples and the split-Rhat diagnostic.
}
