% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{summary.hsstan}
\alias{summary.hsstan}
\title{Summary for the fitted model}
\usage{
\method{summary}{hsstan}(
  object,
  pars = NULL,
  prob = 0.95,
  digits = 2,
  sort = NULL,
  decreasing = TRUE,
  max.rows = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{hsstan}.}

\item{pars}{Vector of parameter names to be extracted. If \code{NULL}
(default) then this refers to the set of predictors used in the
model.}

\item{prob}{Width of the posterior intervals (0.95, by default).}

\item{digits}{Number of decimal places to be reported (2 by default).}

\item{sort}{Column name used to sort the results according to the absolute
value of the column. If \code{NULL} (default) or the column name cannot
be found, no sorting occurs.}

\item{decreasing}{Whether the results should be sorted in decreasing order
when a valid column name is specified in \code{sort} (\code{TRUE} by default).}

\item{max.rows}{Maximum number of rows to be returned. If \code{NULL}
(default) or 0, all results are returned.}

\item{...}{Currently ignored.}
}
\value{
A matrix with summaries from the posterior distribution of the parameters
of interest.
}
\description{
Summary for the fitted model
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
summary(hs.biom)

}
