% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplots.R
\name{makeplots}
\alias{makeplots}
\title{Visualize Causal Tree and the Estimated Results}
\usage{
makeplots(
  negative,
  opfit. = opfit,
  trainset,
  covariates,
  outcomevariable,
  data. = data,
  hte_effect_setup,
  varlabel,
  maintitle,
  legend.x = 0.8,
  legend.y = 0.25,
  ...
)
}
\arguments{
\item{negative}{a logical value indicating whether we expect the
treatment effect to be negative. The default is set as FALSE.}

\item{opfit.}{tree structure generated from causal tree algorithm.}

\item{trainset}{a data frame only containing the variables used in
the model and missings values are listwise deleted.}

\item{covariates}{a vector of column names of all
covariates (linear terms andpropensity score).}

\item{outcomevariable}{a character representing the column name
of the outcome variable.}

\item{data.}{a data frame containing the variables in the model.}

\item{hte_effect_setup}{a empty list to store the adjusted treatment
effect.}

\item{varlabel}{a named vector containing variable labels.}

\item{maintitle}{a character string indicating the main title displayed
when plotting the tree and results. The default is set as
"Heterogeneous Treatment Effect Estimation".}

\item{legend.x, legend.y}{x and y coordinate to position the legend.
The default is set as (0.08, 0.25).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A plot visualizing the tree and estimated treatment effect in each
node.
}
\description{
An intermediate function used for plotting
}
