% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/htmlTable_render.R
\name{prGetRgroupLine}
\alias{prGetRgroupLine}
\title{Gets the number of rgroup htmlLine}
\usage{
prGetRgroupLine(x, total_columns, rgroup, rgroup_iterator, cspan, rnames, align,
  style, cgroup_spacer_cells, col.columns, css.row, padding.tspanner)
}
\arguments{
  \item{x}{The matrix/data.frame with the data. For the
  \code{print} and \code{knit_print} it takes a string of
  the class \code{htmlTable} as \code{x} argument.}

  \item{total_columns}{The total number of columns}

  \item{rgroup}{A vector of character strings containing
  headings for row groups. \code{n.rgroup} must be present
  when \code{rgroup} is given. The first
  \code{n.rgroup[1]}rows are sectioned off and
  \code{rgroup[1]} is used as a bold heading for them. The
  usual row dimnames (which must be present if
  \code{rgroup} is) are indented. The next
  \code{n.rgroup[2]} rows are treated likewise, etc. If you
  don't want a row to be part of a row group then you just
  put "" for that row, remember to add the corresponding
  number of rows in n.rgroup.}

  \item{rgroup_iterator}{An integer indicating the rgroup}

  \item{cspan}{The column span of the current rgroup}

  \item{rnames}{Default rownames are generated from
  \code{\link[base]{rownames}(x)}. If you provide
  \code{FALSE} then it will skip the rownames. \emph{Note:}
  For \code{data.frames} if you do
  \code{\link[base]{rownames}(my_dataframe) <- NULL} it
  still has rownames. Thus you need to use \code{FALSE} if
  you want to surpress rownames for \code{data.frames}.}

  \item{align}{A character strings specifying column
  alignments, defaulting to
  \code{\link[base]{paste}(rep('c',ncol(x)),collapse='')}
  to center. Valid alignments are l = left, c = center and
  r = right. You can also specify \code{align='c|c'} and
  other LaTeX tabular formatting. If you want to set the
  alignment of the rownames this string needst to be
  \code{ncol(x) + 1}, otherwise it automatically pads the
  string with a left alignment for the rownames.}

  \item{style}{The css style corresponding to the rgroup
  css style that includes the color specific for the
  rgroup, i.e. \code{col.rgroup}.}

  \item{cgroup_spacer_cells}{The vector indicating the
  position of the cgroup spacer cells}

  \item{col.columns}{Alternating colors for each column.}

  \item{css.row}{The css.cell information for this
  particular row.}

  \item{padding.tspanner}{The tspanner padding}
}
\description{
Gets the number of rgroup htmlLine
}
\keyword{internal}

