% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txtFrmt.R
\name{txtInt}
\alias{txtInt}
\title{SI or English formatting of an integer}
\usage{
txtInt(x, language = "en", html = TRUE, ...)
}
\arguments{
\item{x}{The integer variable}

\item{language}{The ISO-639-1 two-letter code for the language of
interest. Currently only English is distinguished from the ISO
format using a ',' as the separator.}

\item{html}{If the format is used in HTML context
then the space should be a non-breaking space, \verb{&nbsp;}}

\item{...}{Passed to \code{\link[base:format]{base::format()}}}
}
\value{
\code{string}
}
\description{
English uses ',' between every 3 numbers while the
SI format recommends a ' ' if x > 10^4. The scientific
form 10e+? is furthermore avoided.
}
\examples{
txtInt(123)

# Supplying a matrix
txtInt(matrix(c(1234, 12345, 123456, 1234567), ncol = 2))

# Missing are returned as empty strings, i.e. ""
txtInt(c(NA, 1e7))

}
\seealso{
Other text formatters: 
\code{\link{txtMergeLines}()},
\code{\link{txtPval}()},
\code{\link{txtRound}()}
}
\concept{text formatters}
