% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_clim.R
\name{p_clim}
\alias{p_clim}
\title{Plot climatologies in hydrological year}
\usage{
p_clim(
  files,
  type = "line",
  hydro.month = 1,
  title = "Title",
  yaxis = "Value",
  y.down = NA,
  y.up = NA,
  rpal = FALSE,
  pal = mapalette,
  legend.l = NA
)
}
\arguments{
\item{files}{List of climatology file names}

\item{type}{Type: "line" (default) or bar"}

\item{hydro.month}{Starting month or the hydrological year (default = 1)}

\item{title}{Title of the plot (default = "Title")}

\item{yaxis}{Title of y-axis (default = "Value")}

\item{y.down}{Down limit of y-axis (default = NA)}

\item{y.up}{Up limit of y-axis (default = NA)}

\item{rpal}{Choice of a color palette TRUE/FALSE(default)}

\item{pal}{Color choice or mapalette (default)}

\item{legend.l}{List of text to be displayed in the plot legend (default = NA)}
}
\value{
A ggplot2 object.
}
\description{
This function processes climatology hts files created with
\code{\link{hs_tstep}}.
}
\details{
The parameter tyoe allows to display a line graph or a bar graph.

The parameter hydro.mont fixes the starting month of the hydrological year.

 The y-axis scale can be fixed with y.down and y.up.

 By default, the color palette is the R one. It can be change with a color
 list in the pal parameter or choosing mapalette (default in pal)

 Par default station_sensor ids are displayed in the legend.l list. But it can be changed
 entering a list of texts in legend.l,, which must have the same length as the
 file number.
}
\author{
P. Chevallier - Feb 2017 - Sep 2023
}
