% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_httk.R
\name{convert_httk}
\alias{convert_httk}
\title{Converts HTTK-Pop virtual population into parameters relevant to an HTTK 
model.}
\usage{
convert_httk(indiv.model.bio, model, this.chem,Funbound.plasma.pc.correction=T,
             well.stirred.correction=T,restrictive.clearance=T)
}
\arguments{
\item{indiv.model.bio}{A data.table containing the physiological
parameters as expected by HTTK (from \code{\link{httkpop_bio}}) and
\code{Funbound.plasma} and \code{Clint} values (from
\code{\link{draw_fup_clint}}).}

\item{model}{Which HTTK model to use. One of '1compartment', '3compartmentss',
'3compartment', or 'pbtk'.}

\item{this.chem}{CAS number for the chemical in the HTTK data set for which 
parameters are to be generated.}
 \item{Funbound.plasma.pc.correction}{Uses regressions in calculating partition coefficients if TRUE.}
  \item{well.stirred.correction}{Uses correction in calculation of hepatic clearance for well-stirred model if TRUE for model 1compartment elimination rate.  
                                  This assumes clearance relative to amount unbound in whole blood instead of plasma, but converted to use with plasma concentration.}
 \item{restrictive.clearance}{Protein binding not taken into account (set to 1) in liver clearance if FALSE for model 1compartment elimination rate.}
}
\value{
A data.table whose columns are the parameters of the HTTK model 
 specified in \code{model}.
}
\description{
Converts HTTK-Pop virtual population into parameters relevant to an HTTK 
model.
}

