% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_httk_params.R
\name{get_httk_params}
\alias{get_httk_params}
\title{Converts the HTTK-Pop population data table to a table of the parameters 
needed by HTTK, for a specific chemical.}
\usage{
get_httk_params(indiv_dt, chemcas = NULL, parameters = NULL, model,
  poormetab, fup.censor, sigma.factor = 0.3, Clint.vary = TRUE,
  lod = 0.01, adjusted.Funbound.plasma = T, regression = T,
  well.stirred.correction = T, restrictive.clearance = T,
  clint.pvalue.threshold = 0.05)
}
\arguments{
\item{indiv_dt}{A data table generated by \code{httkpop_generate()}.}

\item{chemcas}{The CAS number of one of the HTTK chemicals (see 
\code{\link[httk]{get_cheminfo}}).}

\item{parameters}{A list of chemical-specific model parameters containing at least
Funbound.plasma, Clint, and Fhep.assay.correction.}

\item{model}{One of the HTTK models: "1compartment", "3compartmentss", 
"3compartment", or "pbtk".}

\item{poormetab}{TRUE (include poor metabolizers) or FALSE (exclude poor 
metabolizers)}

\item{fup.censor}{TRUE (draw \code{Funbound.plasma} from a censored 
distribution) or FALSE (draw \code{Funbound.plasma} from a non-censored 
distribution)}

\item{sigma.factor}{The coefficient of variation to use for \code{Clint} and 
\code{Funbound.plasma} distributions. Default value is 0.3.}

\item{Clint.vary}{TRUE (sample \code{Clint} values) or FALSE (hold 
\code{Clint} fixed). Default TRUE. If \code{Clint.vary} is FALSE, then 
\code{poormetab} will have no effect.}

\item{lod}{The average limit of detection for Funbound.plasma. if 
\code{fup.censor == TRUE}, the \code{Funbound.plasma} distribution will be 
censored below \code{lod/2}. Default value is 0.01.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to TRUE.}

\item{regression}{Whether or not to use the regressions in calculating partition 
coefficients.             
 
 @examples 
 set.seed(42)
 indiv_examp <- httkpop_generate(method="d", 
 nsamp=100)
 httk_param <- get_httk_params(indiv_dt=indiv_examp, 
 chemcas="80-05-7", 
 model="1compartment", 
 poormetab=TRUE, 
 fup.censor=TRUE)}

\item{well.stirred.correction}{If TRUE (default) then the well-stirred 
correction (Rowland et al., 1973) is 
used in the calculation of hepatic clearance for the models that do not
include flows for first-pass metabolism (currently, 1compartment and 
3compartmentss). This assumes clearance relative to amount unbound in whole 
blood instead of plasma, but converted for use with plasma concentration.}

\item{restrictive.clearance}{Protein binding not taken into account (set to 1) in 
liver clearance if FALSE.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in vitro 
clearance assay result has a p-values greater than the threshold are set to zero.}
}
\value{
A data.table whose columns correspond to the parameters of the HTTK 
 model specified in \code{model}, and whose rows correspond to the 
 individuals (rows) of \code{indiv_dt}.                                                                  #' @param well.stirred.correction Uses correction in calculation of hepatic clearance 
for well-stirred model if TRUE for hepatic.model well-stirred. This assumes 
clearance relative to amount unbound in whole blood instead of plasma, but 
converted to use with plasma concentration.
}
\description{
Takes the data table generated by \code{httkpop_generate}, and converts it to
the corresponding table of HTTK model parameters for a specified chemical and
HTTK model.
}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to 
environmental chemicals by simulating toxicokinetic variability." Environment 
International 106 (2017): 105-118

Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. "Clearance 
concepts in pharmacokinetics." Journal of Pharmacokinetics and 
Biopharmaceutics 1.2 (1973): 123-136.
}
\author{
Caroline Ring and John Wambaugh
}
