% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mc_tk.R
\name{calc_mc_tk}
\alias{calc_mc_tk}
\title{Conduct multiple TK simulations using Monte Carlo}
\usage{
calc_mc_tk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  samples = 1000,
  which.quantile = 0.95,
  species = "Human",
  suppress.messages = F,
  model = "pbtk",
  httkpop = T,
  invitrouv = T,
  calcrb2p = T,
  censored.params = list(),
  vary.params = list(),
  return.samples = F,
  tissue = NULL,
  output.units = "mg/L",
  solvemodel.arg.list = list(times = c(0, 0.25, 0.5, 0.75, 1, 1.5, 2, 2.5, 3, 4, 5)),
  invitro.mc.arg.list = list(adjusted.Funbound.plasma = T, poormetab = T,
    fup.censored.dist = FALSE, fup.lod = 0.01, fup.meas.cv = 0.4, clint.meas.cv = 0.3,
    fup.pop.cv = 0.3, clint.pop.cv = 0.3),
  httkpop.generate.arg.list = list(method = "direct resampling", gendernum = NULL,
    agelim_years = NULL, agelim_months = NULL, weight_category = c("Underweight",
    "Normal", "Overweight", "Obese"), gfr_category = c("Normal", "Kidney Disease",
    "Kidney Failure"), reths = c("Mexican American", "Other Hispanic",
    "Non-Hispanic White", "Non-Hispanic Black", "Other")),
  convert.httkpop.arg.list = list(),
  parameterize.arg.list = list(default.to.human = F, clint.pvalue.threshold = 0.05,
    restrictive.clearance = T, regression = T),
  return.all.sims = FALSE
)
}
\arguments{
\item{chem.cas}{Either the CAS number, parameters, or the chemical name must
be specified.}

\item{chem.name}{Either the chemical parameters, name, or the CAS number
must be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from parameterize_steadystate. Not used with
httkpop model.}

\item{samples}{Number of samples generated in calculating quantiles.}

\item{which.quantile}{Which quantile from Monte Carlo simulation is
requested. Can be a vector.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").  Species must be set to "Human" to run httkpop model.}

\item{suppress.messages}{Whether or not to suppress output message.}

\item{model}{Model used in calculation: 'pbtk' for the multiple compartment
model,'3compartment' for the three compartment model, '3compartmentss' for
the three compartment steady state model, and '1compartment' for one
compartment model.  This only applies when httkpop=TRUE and species="Human",
otherwise '3compartmentss' is used.}

\item{httkpop}{Whether or not to use population generator and sampler from
httkpop.  This is overwrites censored.params and vary.params and is only for
human physiology.  Species must also be set to 'Human'.}

\item{invitrouv}{Logical to indicate whether to include in vitro parameters
in uncertainty and variability analysis}

\item{calcrb2p}{Logical determining whether or not to recalculate the 
chemical ratio of blood to plasma}

\item{censored.params}{The parameters listed in censored.params are sampled
from a normal distribution that is censored for values less than the limit
of detection (specified separately for each paramter). This argument should
be a list of sub-lists. Each sublist is named for a parameter in
"parameters" and contains two elements: "CV" (coefficient of variation) and
"LOD" (limit of detection, below which parameter values are censored. New
values are sampled with mean equal to the value in "parameters" and standard
deviation equal to the mean times the CV.  Censored values are sampled on a
uniform distribution between 0 and the limit of detection. Not used with
httkpop model.}

\item{vary.params}{The parameters listed in vary.params are sampled from a
normal distribution that is truncated at zero. This argument should be a
list of coefficients of variation (CV) for the normal distribution. Each
entry in the list is named for a parameter in "parameters". New values are
sampled with mean equal to the value in "parameters" and standard deviation
equal to the mean times the CV. Not used with httkpop model.}

\item{return.samples}{Whether or not to return the vector containing the
samples from the simulation instead of the selected quantile.}

\item{tissue}{Desired steady state tissue conentration.}

\item{output.units}{Plasma concentration units, either uM or default mg/L.}

\item{solvemodel.arg.list}{Additional arguments ultimately passed to 
\code{\link{solve_model}}}

\item{invitro.mc.arg.list}{List of additional parameters passed to 
\code{\link{invitro_mc}}}

\item{httkpop.generate.arg.list}{Additional parameters passed to 
\code{\link{httkpop_generate}}.}

\item{convert.httkpop.arg.list}{Additional parameters passed to the 
convert_httkpop_* function for the model.}

\item{parameterize.arg.list}{Additional parameters passed to the 
parameterize_* function for the model.}

\item{return.all.sims}{Logical indicating whether to return the results
of all simulations, in addition to the default toxicokinetic statistics}
}
\description{
This function finds the analytical steady state plasma concentration(from
calc_analytic_css) using a monte carlo simulation (monte_carlo).
}
\details{
All arguments after httkpop only apply if httkpop is set to TRUE and species
to "Human".

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

Tissue concentrations are calculated for the pbtk model with oral infusion
dosing.  All tissues other than gut, liver, and lung are the product of the
steady state plasma concentration and the tissue to plasma partition
coefficient.

The six sets of plausible \emph{in vitro-in vivo} extrpolation (IVIVE)
assumptions identified by Honda et al. (2019) are: \tabular{lrrrr}{
\tab \emph{in vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical
Conc. \tab TK Statistic Used* \cr Honda1 \tab Veinous (Plasma) \tab
Restrictive \tab Free \tab Mean Conc. \cr Honda2 \tab Veinous \tab
Restrictive \tab Free \tab Max Conc. \cr Honda3 \tab Veinous \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda4 \tab Veinous \tab
Non-restrictive \tab Total \tab Max Conc. \cr Honda5 \tab Target Tissue \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda6 \tab Target Tissue
\tab Non-restrictive \tab Total \tab Max Conc. \cr } *Assumption is
currently ignored because analytical steady-state solutions are currently
used by this function.
}
\examples{

\dontrun{
chemname="Abamectin"
times<- c(0,0.25,0.5,0.75,1,1.5,2,2.5,3,4,5)
age.ranges <- seq(6,80,by=10)
forward <- NULL
for (age.lower in age.ranges)
{
  label <- paste("Ages ",age.lower,"-",age.lower+4,sep="")
  set.seed(1234)
  forward[[label]] <- calc_mc_tk(
                        chem.name=chemname,
                        samples=NSAMP,
                        httkpop.generate.arg.list=list(
                          method="d",
                          agelim_years = c(age.lower, age.lower+9)),
                        solvemodel.arg.list = list(
                          times=times))
}

}
}
\author{
John Wambaugh
}
\keyword{Monte-Carlo}
\keyword{dynamic}
\keyword{simulation}
