% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dawson2021.R
\name{load_dawson2021}
\alias{load_dawson2021}
\title{Load data from Dawson et al. 2021.}
\usage{
load_dawson2021(overwrite = FALSE, exclude_oad = TRUE, target.env = .GlobalEnv)
}
\arguments{
\item{overwrite}{Only matters if load.image=FALSE. If overwrite=TRUE then
existing data in chem.physical_and_invitro.data will be replaced by any
data/predictions in Dawson et al. (2021) that is for the same chemical and
property. If overwrite=FALSE (DEFAULT) then new data for the same chemical
and property are ignored.  Funbound.plasma values of 0 (below limit of
detection) are overwritten either way.}

\item{exclude_oad}{Include the chemicals only within the applicability domain.
If exlude_oad=TRUE (DEFAULT) chemicals outside the applicability domain do not
have their predicted values loaded.}

\item{target.env}{The environment where the new
chem.physical_and_invitro.data is loaded. Defaults to global environment.}
}
\value{
\item{data.frame}{An updated version of
chem.physical_and_invitro.data.}
}
\description{
This function returns an updated version of chem.physical_and_invitro.data
that includes data predicted with Random Forest QSAR models developed and
presented in Dawson et al. 2021, included in dawson2021.
}
\examples{

\dontrun{
chem.physical_and_invitro.data <- load_dawson2021()
chem.physical_and_invitro.data <- load_dawson2021(overwrite=TRUE) 
}                        

}
\references{
\insertRef{dawson2021qsar}{httk}
}
\author{
Sarah E. Davidson
}
