% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_half_life.R
\name{calc_half_life}
\alias{calc_half_life}
\title{Calculates the half-life for a one compartment model.}
\usage{
calc_half_life(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  suppress.messages = FALSE,
  default.to.human = FALSE,
  restrictive.clearance = TRUE,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  well.stirred.correction = TRUE,
  clint.pvalue.threshold = 0.05,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{chem.cas}{Either the cas number or the chemical name must be specified.}

\item{chem.name}{Either the chemical name or the cas number must be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate or
1compartment function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{restrictive.clearance}{In calculating elimination rate, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for -stirred model if TRUE.  This assumes clearance relative
to amount unbound in whole blood instead of plasma, but converted to use
with plasma concentration.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Half life}{Units of h.}
}
\description{
This function calculates the half life from the three compartment
steady state model where elimination is entirely due to metabolism by the
liver and glomerular filtration in the kidneys.
}
\details{
Half life is calculated by dividing the natural-log of 2 by the elimination
rate from the one compartment model.
}
\examples{

calc_half_life(chem.name="Bisphenol A")
calc_half_life(chem.name="Bisphenol A",species="Rat")
calc_half_life(chem.cas="80-05-7")

}
\seealso{
[calc_elimination_rate()] for the elimination rate calculation
}
\author{
Sarah E. Davidson
}
\keyword{1compartment}
\keyword{Parameter}
