% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_caco2.R
\name{get_caco2}
\alias{get_caco2}
\title{Retrieve in vitro measured Caco-2 membrane permeabilit}
\usage{
get_caco2(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  Caco2.Pab.default = 1.6,
  suppress.messages = FALSE
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{Caco2.Pab.default}{sets the default value for  Caco2.Pab if Caco2.Pab is 
unavailable.}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\description{
This function checks for chemical-specific in vitro measurements of the 
Caco-2 membrane permeability 
in the \code{\link{chem.physical_and_invitro.data}} table. If no value is 
available argument \code{Caco2.Pab.default} is returned.
}
\author{
John Wambaugh
}
\keyword{Parameter}
\keyword{oral_bioavailability}
