% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmed0non0u95.R
\name{rmed0non0u95}
\alias{rmed0non0u95}
\title{Draw random numbers with LOD median but non-zero upper 95th percentile}
\usage{
rmed0non0u95(n, x.u95, x.min = 0, x.LOD = 0.005)
}
\arguments{
\item{n}{Number of samples to draw}

\item{x.u95}{The upper limit on the 95th confidence/credible intervale (this
is the 97.5 percentile)}

\item{x.min}{The minimum allowed value (defaults to 0)}

\item{x.LOD}{The limit of detection (defaults to 0.005)}
}
\value{
A vector of N samples where the 50th and 97.5th quantiles approximate
  x.LOD and x.u95 respectively
}
\description{
This function draws N random numbers from a distribution that approximates
a median that is equal to the limit of detection (LOD, value x.LOD) but has 
an upper 95th percentile (x.u95) that is above x.LOD. We make the assumption 
that values above x.u95 are uniformly distributed between x.u95 and x.u95 +
(x.u95 - x.LOD)
}
\examples{
Fup.95 <- 0.02
N <- 1000

set.seed(1235)
Fup.vec <- rmed0non0u95(n=N, x.u95=Fup.95)
quantile(Fup.vec,c(0.5,0.975))

quantile(rmed0non0u95(200,x.u95=0.05,x.min=10^-4,x.LOD=0.01),c(0.5,0.975))
hist(rmed0non0u95(1000,x.u95=0.05,x.min=10^-4,x.LOD=0.01))

quantile(rmed0non0u95(200,x.u95=0.005,x.min=10^-4,x.LOD=0.01),c(0.5,0.975))
hist(rmed0non0u95(1000,x.u95=0.005,x.min=10^-4,x.LOD=0.01))

}
\references{
\insertRef{breen2022simulating}{httk}
}
\author{
John Wambaugh
}
\keyword{httk-pop}
