% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_1tri_pbtk.R
\name{parameterize_1tri_pbtk}
\alias{parameterize_1tri_pbtk}
\title{Parameterize_1tri_PBTK}
\usage{
parameterize_1tri_pbtk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  return.kapraun2019 = TRUE,
  suppress.messages = FALSE,
  ...
)
}
\arguments{
\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{http://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human"). Currently only a human model is supported.}

\item{return.kapraun2019}{If TRUE (default), empirical parameters from 
Kapraun et al. (2019) necessary for defining the model are provided.
This is a subset of the httk::kapraun2019 list object with additional parameters.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{...}{Arguments passed to parameterize_pbtk.}
}
\value{
\item{pre_pregnant_BW}{Body Weight before pregnancy, kg.}
\item{Clmetabolismc}{Hepatic Clearance, L/h/kg BW.} 
\item{Fabsgut}{Fraction of the oral dose absorbed, i.e. the fraction of the dose that enters the gutlumen.}
\item{Funbound.plasma}{Fraction of plasma that is not bound.}
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte
assay using the method of Kilford et al. (2008)} 
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{Kadipose2pu}{Ratio of concentration of chemical in adipose tissue to unbound concentration in plasma.}
\item{Kconceptus2pu_initial}{Ratio of concentration of chemical in "conceptus" 
compartment to unbound concentration in plasma at time 0.} 
\item{Kconceptus2pu_final}{Ratio of concentration of chemical in "conceptus" 
compartment to unbound concentration in plasma at 13 weeks.} 
\item{Kgut2pu}{Ratio of concentration of chemical in gut tissue to unbound 
concentration in plasma.} 
\item{kgutabs}{Rate that chemical enters the gut from 
gutlumen, 1/h.} 
\item{Kkidney2pu}{Ratio of concentration of chemical in kidney tissue 
to unbound concentration in plasma.} 
\item{Kliver2pu}{Ratio of concentration of chemical in liver tissue to unbound concentration in plasma.}
\item{Klung2pu}{Ratio of concentration of chemical in lung tissue to unbound
concentration in plasma.} 
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells to unbound concentration in plasma.}
\item{Krest2pu}{Ratio of concentration of chemical in rest of body tissue to
unbound concentration in plasma.} 
\item{Kthyroid2pu}{Ratio of concentration of chemical in thyroid tissue to unbound concentration in plasma.}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.} 
\item{MW}{Molecular Weight, g/mol.} 
\item{pH_Plasma_mat}{pH of the maternal plasma.}
\item{Qgfr}{Glomerular Filtration Rate, L/h/kg BW^3/4, volume of fluid
filtered from kidney and excreted.} 
\item{Vgutc}{Volume of the gut per kg body weight, L/kg BW.} 
\item{Vkidneyc}{Volume of the kidneys per kg body weight, L/kg BW.} 
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{Vlungc}{Volume of the lungs per kg body weight, L/kg BW.}
\item{Vthyroidc}{Volume of the thyroid per kg body weight, L/kg BW.}
}
\description{
This function initializes the parameters needed in the functions
solve_1tri_pbtk by calling parameterize_pbtk and adding additional parameters.
}
\details{
Because this model does not simulate exhalation, inhalation, and other 
processes relevant to volatile chemicals, this model is by default 
restricted to chemicals with a logHenry's Law Constant less than that of 
Acetone, a known volatile chemical. That is, chemicals with logHLC > -4.5 
(Log10 atm-m3/mole) are excluded. Volatility is not purely determined by the 
Henry's Law Constant, therefore this chemical exclusion may be turned off 
with the argument "physchem.exclude = FALSE". Similarly, per- and 
polyfluoroalkyl substances (PFAS) are excluded by default because the 
transporters that often drive PFAS toxicokinetics are not included in this 
model. However, PFAS chemicals can be included with the argument 
"class.exclude = FALSE".
}
\examples{

\donttest{
 parameters <- parameterize_1tri_pbtk(dtxsid = "DTXSID7020182")

 parameters <- parameterize_1tri_pbtk(chem.name='Bisphenol-A')
} 

}
\references{
\insertRef{kilford2008hepatocellular}{httk}

\insertRef{kapraun2019empirical}{httk}

\insertRef{kapraun2022fetalmodel}{httk} 

\insertRef{truong2025fullpregnancy}{httk}
}
\seealso{
\code{\link{solve_1tri_pbtk}}

\code{\link{parameterize_pbtk}}

\code{\link{predict_partitioning_schmitt}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}

\code{\link{kapraun2019}}
}
\author{
Kimberly Truong, Mark Sfeir, Dustin Kapraun, John Wambaugh
}
\keyword{Parameter}
