% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-verbs.R
\name{cached-http-verbs}
\alias{DELETE}
\alias{GET}
\alias{PATCH}
\alias{POST}
\alias{PUT}
\alias{cached-http-verbs}
\title{Cache-aware versions of httr verbs}
\usage{
GET(url, ...)

PUT(url, ..., drop = dropCache(url))

POST(url, ..., drop = dropOnly(url))

PATCH(url, ..., drop = dropCache(url))

DELETE(url, ..., drop = dropCache(url))
}
\arguments{
\item{url}{character URL of the request}

\item{...}{additional arguments passed to the httr functions}

\item{drop}{For \code{PUT}, \code{PATCH}, \code{POST}, and \code{DELETE},
code to be executed after the request. This is intended to be for supplying
cache-invalidation logic. By default, \code{POST} drops cache only for
the specified \code{url} (i.e. \code{\link{dropOnly}}), while the other
verbs drop cache for the request URL and for any URLs nested below it
(i.e. \code{\link{dropCache}}).}
}
\value{
The corresponding httr response object, potentially read from cache
}
\description{
These functions set, read from, and bust the HTTP query cache. They wrap
the similarly named functions in the httr package and can be used as
drop-in replacements for them.
}
\details{
\code{GET}
checks the cache before making an HTTP request, and if there is a cache
miss, it sets the response from the request into the cache for future
requests. The other verbs, assuming a more or less RESTful API, would be
assumed to modify server state, and thus they should trigger cache
invalidation. They have default cache-invalidation strategies, but you can
override them as desired.
}
\seealso{
\code{\link{dropCache}} \code{\link{cachedPOST}} \code{\link{cachedDownload}}
}

