% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticServer.R
\name{runStaticServer}
\alias{runStaticServer}
\title{Serve a directory}
\usage{
runStaticServer(
  dir = getwd(),
  host = "127.0.0.1",
  port = NULL,
  ...,
  background = FALSE,
  browse = interactive()
)
}
\arguments{
\item{dir}{The directory to serve. Defaults to the current working directory.}

\item{host}{A string that is a valid IPv4 address that is owned by this
server, or \code{"0.0.0.0"} to listen on all IP addresses.}

\item{port}{A number or integer that indicates the server port that should be
listened on. Note that on most Unix-like systems including Linux and Mac OS
X, port numbers smaller than 1025 require root privileges.}

\item{...}{
  Arguments passed on to \code{\link[=staticPath]{staticPath}}
  \describe{
    \item{\code{path}}{The local path.}
    \item{\code{indexhtml}}{If an index.html file is present, should it be served up
when the client requests the static path or any subdirectory?}
    \item{\code{fallthrough}}{With the default value, \code{FALSE}, if a request is made
for a file that doesn't exist, then httpuv will immediately send a 404
response from the background I/O thread, without needing to call back into
the main R thread. This offers the best performance. If the value is
\code{TRUE}, then instead of sending a 404 response, httpuv will call the
application's \code{call} function, and allow it to handle the request.}
    \item{\code{html_charset}}{When HTML files are served, the value that will be
provided for \code{charset} in the Content-Type header. For example, with
the default value, \code{"utf-8"}, the header is \code{Content-Type:
  text/html; charset=utf-8}. If \code{""} is used, then no \code{charset}
will be added in the Content-Type header.}
    \item{\code{headers}}{Additional headers and values that will be included in the
response.}
    \item{\code{validation}}{An optional validation pattern. Presently, the only type of
validation supported is an exact string match of a header. For example, if
\code{validation} is \code{'"abc" = "xyz"'}, then HTTP requests must have a
header named \code{abc} (case-insensitive) with the value \code{xyz}
(case-sensitive). If a request does not have a matching header, than httpuv
will give a 403 Forbidden response. If the \code{character(0)} (the
default), then no validation check will be performed.}
  }}

\item{background}{Whether to run the server in the background. By default,
the server runs in the foreground and blocks the R console. You can stop
the server by interrupting it with \code{Ctrl + C}.

When \code{background = TRUE}, the server will run in the background and will
process requests when the R console is idle. To stop a background server,
call \code{\link[=stopAllServers]{stopAllServers()}} or call \code{\link[=stopServer]{stopServer()}} on the server object
returned (invisibly) by this function.}

\item{browse}{Whether to automatically open the served directory in a web
browser. Defaults to \code{TRUE} when running interactively.}
}
\value{
Starts a server on the specified host and port. By default the
server runs in the foreground and is accessible at \verb{http://127.0.0.1:7446}.
When \code{background = TRUE}, the \code{server} object is returned invisibly.
}
\description{
\code{runStaticServer()} provides a convenient interface to start a server to host
a single static directory, either in the foreground or the background.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
website_dir <- system.file("example-static-site", package = "httpuv")
runStaticServer(dir = website_dir)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=runServer]{runServer()}} provides a similar interface for running a dynamic
app server. Both \code{runStaticServer()} and \code{\link[=runServer]{runServer()}} are built on top of
\code{\link[=startServer]{startServer()}}, \code{\link[=service]{service()}} and \code{\link[=stopServer]{stopServer()}}. Learn more about httpuv
servers in \code{\link[=startServer]{startServer()}}.
}
