% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{with_verbosity}
\alias{with_verbosity}
\title{Temporarily set verbosity for all requests}
\usage{
with_verbosity(code, verbosity = 1)
}
\arguments{
\item{code}{Code to execture}

\item{verbosity}{How much information to print? This is a wrapper
around \code{req_verbose()} that uses an integer to control verbosity:
\itemize{
\item 0: no output
\item 1: show headers
\item 2: show headers and bodies
\item 3: show headers, bodies, and curl status messages.
}}
}
\value{
The result of evaluating \code{code}.
}
\description{
\code{with_verbose()} is useful for debugging httr2 code buried deep inside
another package because it allows you to see exactly what's been sent
and requested.
}
\examples{
fun <- function() {
  request("https://httr2.r-lib.org") \%>\% req_perform()
}
with_verbosity(fun())
}
