% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydrobio.R
\name{get_hydrobio_stations_hydrobio}
\alias{get_hydrobio_stations_hydrobio}
\alias{get_hydrobio_indices}
\alias{get_hydrobio_taxons}
\title{Retrieve data from API "Hydrobiologie"}
\usage{
get_hydrobio_stations_hydrobio(...)

get_hydrobio_indices(...)

get_hydrobio_taxons(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
The data originate from the "NAIADES" database.
Available endpoints are:
\itemize{
\item \code{get_hydrobio_stations_hydrobio} retrieves site data and locations
\item \code{get_hydrobio_indices} retrieves bioassessment indices values
\item \code{get_hydrobio_taxons} retrieves taxa data
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-hydrobiologie}
}
\examples{
\dontrun{
# Retrieve the hydrobiology monitoring sites in the Pays-de-Loire region
list_params(api = "hydrobio",
            endpoint = "stations_hydrobio")

get_hydrobio_stations_hydrobio(code_region = 52)

# Retrieve the hydrobiological bioassessment indices in the city of Rennes
list_params(api = "hydrobio",
            endpoint = "indices")

get_hydrobio_indices(code_commune = 35051)

# species records in the city of Rennes
list_params(api = "hydrobio",
            endpoint = "taxons")

get_hydrobio_taxons(code_commune = 35051)
}
}
