\name{huge.stars}
\alias{huge.stars}
\title{
StARS: Stability Approach to Regularization Selection
}
\description{
Implements the Stability Approah to Regularization Selection (StARS).
}
\usage{
huge.stars(R.path, stars.thresh = 0.1, verbose = TRUE)
}
\arguments{
  \item{R.path}{
A list of multiple solution paths. Each solution path is a list of adjacency matrix of estimated graphs using a subsample.
}
  \item{stars.thresh}{
The varability threshold in stability selection. The default value is \code{0.1}. An alternative value is \code{0.05}.
}
  \item{verbose}{
If \code{verbose = FALSE}, tracing information printing is disabled. The default value is \code{TRUE}.
}
}
\details{
The StARS selects the optimal regularization parameter using the variability of solution paths by subsampling. It can be applied to multiple solution paths generated by subsampling. An alternative threshold \code{0.05} is chosen under the assumption that  the model is correctly specified. In applications, the model is usually misspecified, \code{0.1} is a better choise for a safer selection.
}
\value{
The index of the optimal regularization parameter is returned.
}
\author{
Tuo Zhao, Han Liu, Kathryn Roeder, John Lafferty, and Larry Wasserman \cr
Maintainers: Tuo Zhao<tourzhao@andrew.cmu.edu>; Han Liu <hanliu@cs.jhu.edu>
}
\references{
Tuo Zhao and Han Liu. HUGE: A Package for High-dimensional Undirected Graph Estimation. Technical Report, Carnegie Mellon University, 2010\cr
Han Liu, Kathryn Roeder and Larry Wasserman. Stability Approach to Regularization Selection (StARS) for High Dimensional Graphical Models. \emph{Advances in Neural Information Processing Systems}, 2010.
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{huge.select}},\code{\link{huge}} and \code{\link{huge-package}}
}
\examples{
#generate data
n = 100
L = huge.generator(n=100, graph = "hub")

#subset indices
ind.group = c(1:30)

#preselect the neighborhood
ind.mat = huge.scr(L$data)$ind.mat
lambda = exp(seq(log(1),log(0.1),length=10))

#subsampling and subgraph estimation
R.path = list()
for(k in 1:6){
    ind.sample = sample(c(1:n), floor(n*0.8), replace=FALSE)
    R.path[[k]] = huge.subgraph(L$data[ind.sample,], ind.group = ind.group, 
    ind.mat = ind.mat, lambda = lambda)$path 
}

#stability selection
D = huge.stars(R.path)
}