% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{flatten}
\alias{flatten}
\title{Convert multidimensional array of counts per state into table form. Each row in the table corresponds to one individual}
\usage{
flatten(stateOccupancies, categoryNames)
}
\arguments{
\item{stateOccupancies}{an arbitrary-dimension array of (integer) state occupation counts.}

\item{categoryNames}{a string vector of unique column names.}
}
\value{
a DataFrame with columns corresponding to category values and rows corresponding to individuals.
}
\description{
This function
}
\examples{
gender=c(51,49)
age=c(17,27,35,21)
states=qis(list(1,2),list(gender,age))$result
table=flatten(states,c("Gender","Age"))
print(nrow(table[table$Gender==1,])) # 51
print(nrow(table[table$Age==2,])) # 27
}
