% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.cyto}
\alias{get.cyto}
\title{Return Cytoband/Karyotype locations across the genome}
\usage{
get.cyto(build = NULL, dir = NULL, bioC = TRUE, GRanges = TRUE,
  refresh = FALSE)
}
\arguments{
\item{build}{string, currently 'hg18' or 'hg19' to specify which annotation version to use. 
Default is build-36/hg-18. Will also accept integers 36,37 as alternative arguments.}

\item{dir}{character, location to store file with the this annotation.
If NULL then getOption("save.annot.in.current")>=1 will result in
this file being stored in the current directory, or if <=0, then this file will not
be stored.}

\item{bioC}{logical, whether to return the annotation as a ranged S4 object (GRanges or
RangedData), or as a data.frame}

\item{GRanges}{logical, whether to return a GRanges object, or FALSE to return RangedData}

\item{refresh}{logical, whether to re-download the file if the existing file has become corrupted}
}
\value{
Returns a list, GRanges or RangedData object, depending on input parameters. Contained
will be centromere chromosome and start and end positions.
}
\description{
Returns the locations of cytobands/karyotype-bands in the human genome, for a given build, as
a data.frame, or GRanges/RangedData object.
}
\examples{
require(BiocInstaller)
setwd(tempdir())
get.cyto()
cyto.frame <- get.cyto(bioC=FALSE)
prv(cyto.frame)
get.cyto(build=36)
}

