% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted_quantile}
\alias{weighted_quantile}
\title{Weighted quantile}
\usage{
weighted_quantile(v, w = NULL, p = (0:4)/4, v_is_sorted = FALSE)
}
\arguments{
\item{v}{A vector from which sample quantiles are desired.}

\item{w}{Weights corresponding to each \code{v}.}

\item{p}{Numeric vector of probabilities. Missing values or values outside
\eqn{[0, 1]} raise an error.}

\item{v_is_sorted}{(logical, default: \code{FALSE}) If \code{TRUE}, ordering
\code{v} is assumed to be sorted. Only set to \code{TRUE} when it is certain
that \code{v} is sorted (as within groups of tables).}
}
\value{
A vector the same length as \code{p}, the quantiles corresponding
to each element of \code{p}.
}
\description{
\code{quantile} when the values are weighted
}
