% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samp.R
\name{samp}
\alias{samp}
\title{Safer sampler}
\usage{
samp(x, size = length(x), replace = size > length(x), loud = TRUE, prob = NULL)
}
\arguments{
\item{x}{A vector.}

\item{size}{A non-negative integer, the number of items to return.}

\item{replace}{Should the sampling be done with replacement? Defaults to \code{TRUE} if 
\code{size > length(x)}, with a message.}

\item{loud}{If \code{TRUE}, the default, any behaviour known to be different from 
\code{\link[base]{sample}} is flagged with a message.}

\item{prob}{As in \code{\link[base]{sample}}.}
}
\description{
Present since \code{hutils v1.4.0}. 
Same as \code{\link[base]{sample}}, but avoiding the behaviour when 
\code{length(x) == 1L}.
}
\examples{
samp(1:5)
sample(1:5)

samp(1:5, size = 10)  # no error
tryCatch(sample(1:5, size = 10), 
         error = function(e) print(e$m))

samp(5, size = 3)
sample(5, size = 3)


}
