% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{na_string}
\alias{na_string}
\alias{na_string<-}
\alias{set_na_string}
\alias{na_string.huxtable}
\alias{na_string<-.huxtable}
\title{Get or Set String to Use For NA}
\usage{
na_string(ht)
na_string(ht) <- value
set_na_string(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character string. This will be used to replace NA values in the display. Set to \code{NA} for the default, which is the empty string. To get literal "NA", set to "NA". Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{na_string}, the \code{na_string} attribute.
For \code{set_na_string}, the \code{ht} object.
}
\description{
Functions to get or set the string to use for na property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
na_string(ht) <-  '--'
na_string(ht)
print_screen(ht)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
