% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{right_border}
\alias{right_border}
\alias{right_border<-}
\alias{set_right_border}
\alias{right_border.huxtable}
\alias{right_border<-.huxtable}
\title{Get or Set Right Border}
\usage{
right_border(ht)
right_border(ht) <- value
set_right_border(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector or matrix giving border widths. Set to 0 for no border. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{right_border}, the \code{right_border} attribute.
For \code{set_right_border}, the \code{ht} object.
}
\description{
Functions to get or set the right border property of huxtable table cells.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
right_border(ht) <-  1
right_border(ht)
print_screen(ht)
}
\seealso{
Other borders: \code{\link{bottom_border}},
  \code{\link{left_border}}, \code{\link{top_border}}
}
