% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{left_border_style}
\alias{left_border_style}
\alias{left_border_style<-}
\alias{set_left_border_style}
\alias{right_border_style}
\alias{top_border_style}
\alias{bottom_border_style}
\alias{right_border_style<-}
\alias{top_border_style<-}
\alias{bottom_border_style<-}
\alias{set_right_border_style}
\alias{set_top_border_style}
\alias{set_bottom_border_style}
\title{Border styles}
\usage{
left_border_style(ht)
left_border_style(ht) <- value
set_left_border_style(ht, row, col, value, byrow = FALSE)

right_border_style(ht)
right_border_style(ht) <- value
set_right_border_style(ht, row, col, value, byrow = FALSE)

top_border_style(ht)
top_border_style(ht) <- value
set_top_border_style(ht, row, col, value, byrow = FALSE)

bottom_border_style(ht)
bottom_border_style(ht) <- value
set_bottom_border_style(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix of styles, which may be "solid", "double", "dashed" or "dotted". Set to \code{NA} to reset to the default, which is
\code{"solid"}.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{left_border_style}, the \code{left_border_style} property.
For \code{set_left_border_style}, the \code{ht} object.

Similarly for the other functions.
}
\description{
Functions to get or set the \emph{border styles} property of huxtable cells.
}
\details{
Huxtable collapses borders and border colors. Right borders take priority over left borders, and
top borders take priority over bottom borders.

Border styles only apply if the border width is greater than 0.
}
\section{Quirks}{

\itemize{
\item In HTML, you will need to set a width of at least 3 to get a double border.
\item Only "solid" and "double" styles are currently implemented in LaTeX.
}
}

\section{Note}{

huxtable currently sets borders on specific cells. This can lead to surprising behaviour when
cells span multiple rows or columns: see the example. This behaviour may be improved in a future
release.
}

\examples{
ht <- huxtable(a = 1:3, b = 3:1)
ht <- set_all_borders(ht, 1)
set_left_border_style(ht, 'double')
set_left_border_style(ht, 1:2, 1, 'double')
set_left_border_style(ht, 1:2, 1:2, c('solid', 'double'), byrow = TRUE)
set_left_border_style(ht, where(ht == 1), 'double')
# When cells span multiple rows:
ht <- tribble_hux(
  ~Col1,                   ~Col2,
  "Cell 1,1 spans 2 rows", "Cell 1,2",
  "Cell 2,1 is invisible", "Cell 2,2"
)
rowspan(ht)[1, 1] <- 2
ht
bottom_border(ht)[2, ] <- 1
bottom_border_color(ht)[2, ] <- 'red'
# Cell 1, 1 does not have a border set:
ht
# Fixed:
bottom_border(ht)[1, 1] <- 1
bottom_border_color(ht)[1, 1] <- 'red'
ht
}
