% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-docs.R
\docType{package}
\name{huxtable-FAQ}
\alias{huxtable-FAQ}
\title{Frequently Asked Questions, including how to get help}
\description{
A FAQ of common issues.
}
\details{
\itemize{
\item I get a LaTeX error when I try to compile my document!

Have you installed the LaTeX packages you need? LaTeX packages are different
from R packages. Run \code{\link[=check_latex_dependencies]{check_latex_dependencies()}} to find out if you are
missing any. Then install them using your system's LaTeX management
application. Or you can try \code{\link[=install_latex_dependencies]{install_latex_dependencies()}}.

In some rmarkdown and LaTeX formats, you also need to add LaTeX dependencies
manually. Run \code{\link[=report_latex_dependencies]{report_latex_dependencies()}} and add
the output to your LaTeX preamble, or in Rmarkdown formats, add it to the
rmarkdown header like this:\preformatted{header-includes:
  - \\usepackage\{array\}
  - \\usepackage\{caption\}
  ... et cetera
}
\item Huxtable isn't working in my Rmarkdown \code{beamer_presentation} slides.

You may need to set the beamer "fragile" option, like this:\preformatted{# Slide title \{.fragile\}
}
\item Numbers in my cells look weird!

You can change numeric formatting using \code{\link[=number_format]{number_format()}}. Base R options
like \code{\link[base:options]{scipen}} usually have no effect.
\item I ran \code{caption(ht) <- "Something"} and got an error message:\preformatted{Error in UseMethod("caption<-") :
no applicable method for 'caption<-' applied to an object of class "c('huxtable',   'data.frame')"
}

You may have loaded another package with a \code{caption} method, e.g. "xtable".
Try loading huxtable after xtable.
\item How can I change the font size, font etc. of captions?

There are no direct commands for this. You have to use raw HTML/TeX/other
commands within the caption itself. For example to have a bold caption in
HTML, you might do something like:\preformatted{set_caption(jams, "<b>Jam Prices</b>")
}
\item How do I refer to tables in bookdown?

As of version 4.3.0, this is handled automatically for you. Just
set the label using \code{\link[=label]{label()}}, then in markdown text do e.g.:\preformatted{\\@ref(tab:my-table-label).

}
\item I called \code{library(huxtable)} and now my \code{data.table} objects are getting
printed!

Set \code{options(huxtable.knit_print_df = FALSE)}.
\item How can I set a property on an arbitrary group of cells?

If you can't use the \link{mapping-functions} interface, and you want to
set a property for multiple cells that aren't all in the same rows
and/or columns, you could use a little-known fact about R subsetting.
If you subset \code{ht[x]} where \code{x} is two-column numeric matrix, then
each row of \code{x} indexes a single \verb{(row, column)} cell. So, for example,
here's how to set the background color of cells \verb{(2,1)}, \verb{(1, 3)} and
\verb{(4, 2)} of a huxtable:\preformatted{indices <- matrix(c(2, 1, 1, 3, 4, 2), ncol = 2, byrow = TRUE)
background_color(jams)[indices] <- "orange"
}

Another useful trick sets properties on the diagonal, using \code{\link[=diag]{diag()}}:\preformatted{diag(background_color(jams)) <- "grey"
}
\item I have another problem.

If you have a bug - i.e. a problem with the software - or have a feature
request, please report it to
\url{https://github.com/hughjonesd/huxtable/issues}.
Otherwise, ask a question on \href{https://stackoverflow.com}{StackOverflow} or
\url{https://community.rstudio.com}. That way, other people will benefit from
the answers you get.
\item Can I email you directly?

I'd rather you asked on a public website. If you then email me a link, I
may be able to help.
}
}
