\name{hybridHclust}
\alias{hybridHclust}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Hybrid hierarchical clustering using mutual clusters.}
\description{
  Top-down clustering (\code{tsvq}) is applied to data with constraint that
mutual clusters cannot be divided.  Within each mutual cluster, tsvq is re-applied to
yeild a top-down hybrid in which mutual cluster structure is retained.
}
\usage{ hybridHclust(x, themc=NULL, trace=FALSE) }
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A data matrix whose rows are to be clustered}
  \item{themc}{An object representing the mutual clusters in x, typically
generated by \code{mutualCluster}. If it is not provided, it will be calculated.  }
  \item{trace}{Should internal steps be printed as they execute?}
}
\details{
A mutual cluster is a set of points that should never be broken (see help
for \sQuote{mutualCluster} for a more precise definition).  \code{hybridHcclust} uses this idea to
construct a top-down clustering in which mutual clusters are never broken.
This is achieved by temporarily \dQuote{fusing} together all points in a
mutual cluster
so that they have equal coordinates, running \code{tsvq}, and then
re-running \code{tsvq} within each mutual cluster.  The resultant top-down clusterings
are then \dQuote{stitched} together to form a single top-down clustering.

  Only maximal mutual clusters are constrained to not be broken.  Thus if
points A, B, C, D are a mutual cluster and points A, B are also a mutual cluster, only the four
points will be forbidden from being broken.
}
\value{
  A dendrogram in \code{hclust} format.
}
\author{Hugh Chipman}

\seealso{tsvq}
\examples{
x <- cbind(c(-1.4806,1.5772,-0.9567,-0.92,-1.9976,-0.2723,-0.3153),
c( -0.6283,-0.1065,0.428,-0.7777,-1.2939,-0.7796,0.012))
hyb1 <- hybridHclust(x)
par(mfrow=c(1,2))
plot(x, pch = as.character(1:nrow(x)), asp = 1)
plot(hyb1)

# also works 
mc1 <- mutualCluster(x)
hyb1 <- hybridHclust(x,mc1)
}
\keyword{cluster}
