% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_HM.R
\name{summary}
\alias{summary}
\alias{summary.HM}
\title{summary for hybrid models}
\usage{
\method{summary}{HM}(object, at = NULL, stateVars = NULL, nodes = NULL, ...)
}
\arguments{
\item{object}{\code{HM} object}

\item{at}{the date (as character) that will be used to print the summary}

\item{stateVars}{\code{\link{vector}} containing the state variable to
summarize. The default value is NULL, which will print a
summary with all states.}

\item{nodes}{\code{\link{vector}} containing the nodes of interest. The
default value is NULL, which will print a summary with all
nodes.}

\item{...}{arguments to be passed to methods.}
}
\description{
\code{summary.HM} is a method to print a summary with basic
              description of nodes' states at a specific time (the time must
              be present in the network data). The default value is Null,
              that means it prints nodes' final states.
}
\examples{
# Parameters and initial conditions for an SIS model
# loading the data set 
data(networkSample) # help("networkSample"), for more info
networkSample <- networkSample[which(networkSample$Day < "2012-03-20"),]

var.names <- list(from = 'originID', to = 'destinationID', Time = 'Day',
                  arc = 'num.animals')
                  
prop.func <- c('beta * S * I / (S + I)', 'gamma * I')
state.var <- c('S', 'I')
state.change.matrix <- matrix(c(-1,  1,  # S
                                 1, -1), # I
                              nrow = 2, ncol = 2, byrow = TRUE)
                              
model.parms <- c(beta = 0.1, gamma = 0.01)

init.cond <- rep(100, length(unique(c(networkSample$originID,
                                      networkSample$destinationID))))
names(init.cond) <- paste('S', unique(c(networkSample$originID,
                                        networkSample$destinationID)), sep = '')
init.cond <- c(init.cond, c(I36811 = 10, I36812 = 10)) # adding infection
                  
# running simulations, check num of cores available (num.cores)
sim.results <- hybridModel(network = networkSample, var.names = var.names,
                           model.parms = model.parms, state.var = state.var,
                           prop.func = prop.func, init.cond = init.cond,
                           state.change.matrix = state.change.matrix,
                           sim.number = 4, num.cores = 2)

summary(sim.results, stateVars = c('S', 'I'), nodes = c(36812, 36813))

}
