% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridogram.R
\name{hybridogram}
\alias{hybridogram}
\title{Function that Creates a Heat Map from Hybridization Data}
\arguments{
\item{hybrid_data}{a data frame with three columns: species1, species2, code}

\item{codes}{a data frame with two columns: code, description}
}
\value{
nil
}
\description{
R package which takes a list of hybridization results along
with a code and creates a heat map.

Version 2.3
Author: Dr. Matthew Cserhati
Email: csmatyi@protonmail.com
May 15, 2021
}
\examples{
V1 <- c("Phoca largha","Phoca largha","Phoca caspica")
V2 <- c("Phoca vitulina","Phoca caspica","Pusa hispida")
V3 <- c(2,3,3)
hybrid_data <- data.frame(V1,V2,V3)
C1 <- c(1,2,3)
C2 <- c("No hybrid","Documented hybrid","Hybrid with same 3rd species")
codes <- data.frame(C1,C2)
hybridogram(hybrid_data, codes)

}
\references{
Wood, T. C., and Murray, M. J. (2003) Understanding the Pattern of Life. Nashville, TN: Broadman & Holman.
}
