% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{getTime}
\alias{getTime}
\alias{getTime,WaterLevelDataFrame-method}
\alias{getTime-method}
\title{Extract a WaterLevelDataFrame's slot time}
\usage{
getTime(x)

\S4method{getTime}{WaterLevelDataFrame}(x)
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
The function above extracts the slot \code{time} and returns an
  object of type \code{\link[base:POSIXct]{c("POSIXct", "POSIXt")}}.
}
\description{
A function to extract the slot \code{time} from an object of
  class \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
getTime(wldf)

}
\seealso{
\code{\link[=setTime<-]{setTime<--method}}
}
