% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traverse_flowlines.R
\name{traverse_flowlines}
\alias{traverse_flowlines}
\title{traverse_flowlines}
\usage{
traverse_flowlines(max_distance, start, direction = c("out", "in"),
  dataset = c("nhdh", "nhdplusv2"), max_steps = 10000, db_path = NULL)
}
\arguments{
\item{max_distance}{maximum distance to traverse in km. If negative, traverse until the ocean (node 0) or max_steps is reached.}

\item{start}{character node to start}

\item{direction}{character; either "out" or "in"}

\item{dataset}{which network dataset to traverse. May be either NHD high-res or NHD Plus v2.}

\item{max_steps}{maximum traversal steps before terminating}

\item{db_path}{manually specify path to flowtable database. Useful for avoiding database locks when running traversals in parallel.}
}
\value{
dataframe of nodes traversed, distance from the start node to each node, and the children of each node.
}
\description{
traverse hydrological network
}
\examples{
\dontrun{
traverse_flowlines(1000, "141329377", "out", "nhdh")
# this example traverses until a cycle is found and the end of the network is reached.
}
}
