% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_index_ids.R
\name{format_index_ids}
\alias{format_index_ids}
\title{Format Index ids}
\usage{
format_index_ids(g, return_list = FALSE)
}
\arguments{
\item{g}{data.frame graph with \code{id}, \code{inid} and \code{toindid} as returned by \link{make_index_ids}
with \code{long_form}=TRUE.}

\item{return_list}{logical if TRUE, the returned list will include a
"froms_list" element containing all from ids in a list form.}
}
\value{
list containing an adjacency matrix and a lengths vector indicating
the number of connections from each node. If \code{complete} is \code{TRUE} return
will also include a data.frame with an \code{indid} column and a \code{toindid} list
column.
}
\description{
Format Index ids
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

y <- add_toids(x) |>
  make_index_ids(long_form = TRUE) |>
  format_index_ids()

}
