% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{merge_time}
\alias{merge_time}
\title{Merge Events}
\usage{
merge_time(
  Sx,
  Sy,
  relation,
  timeLag = c(1, 1, 1),
  TimeFormat = "\%Y-\%m-\%d \%H:\%M",
  tz = "Etc/GMT-1"
)
}
\arguments{
\item{Sx}{Data frame that consists of flow fluctuation events and computed
metrics (see \code{\link[hydropeak:get_events]{hydropeak::get_events()}})
of an upstream hydrograph \eqn{S_{x}}{S_x}.}

\item{Sy}{Data frame that consists of flow fluctuation events and computed
metrics (see \code{\link[hydropeak:get_events]{hydropeak::get_events()}})
of a downstream hydrograph \eqn{S_{y}}{S_y}.}

\item{relation}{Data frame that contains the relation between upstream and
downstream hydrograph. Must only contain two rows (one for each hydrograph)
in order of their location in downstream direction.
See the appended example data \code{relation.csv} or vignette for details on
the structure. See \code{\link[=get_lag]{get_lag()}} for further information
about the relation and the lag between the hydrographs.}

\item{timeLag}{Numeric vector specifying factors to alter the interval to capture
events from the downstream hydrograph. By default it is
\code{timeLag = c(1, 1, 1)}, this refers to matches within a time slot
\eqn{\pm} the mean translation time from \code{relation}. For exact time
matches, \code{timeLag = c(0, 1, 0)} must be specified.}

\item{TimeFormat}{Character string giving the date-time format of the
date-time column in the input data frame  (default: "\%Y-\%m-\%d \%H:\%M").}

\item{tz}{Character string specifying the time zone to be used for the
conversion (default: "Etc/GMT-1").}
}
\value{
Data frame that has a matched event at \eqn{S_{x}}{S_x} and
    \eqn{S_{y}}{S_y} in each row.
}
\description{
Given two event data frames of neighboring stations \eqn{S_{x}}{S_x}
    and \eqn{S_{y}}{S_y} that consist of flow fluctuation events and computed
    metrics (see \code{\link[hydropeak:get_events]{hydropeak::get_events()}}),
    the translation time between these two stations is subtracted from \eqn{S_{y}}{S_y}
    and events are merged where exact matches can be found.
}
\examples{
Sx <- system.file("testdata", "Events", "100000_2_2014-01-01_2014-02-28.csv",
                  package = "hydroroute")
Sy <- system.file("testdata", "Events", "200000_2_2014-01-01_2014-02-28.csv",
                  package = "hydroroute")
relation <- system.file("testdata", "relation.csv", package = "hydroroute")
# read data
Sx <- utils::read.csv(Sx)
Sy <- utils::read.csv(Sy)
relation <- utils::read.csv(relation)
relation <- relation[1:2, ]

# exact matches
merged <- merge_time(Sx, Sy, relation, timeLag = c(0, 1, 0))
head(merged)

# matches within +/- mean translation time
merged <- merge_time(Sx, Sy, relation)
head(merged)
}
