% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_hm_mutate.R
\name{hm_mutate}
\alias{hm_mutate}
\alias{hm_mutate,hydromet_station-method}
\alias{hm_mutate,hydromet_compact-method}
\title{Create, modify and delete columns inside a slot}
\usage{
hm_mutate(obj, slot_name, FUN, ...)

\S4method{hm_mutate}{hydromet_station}(obj, slot_name, FUN, ...)

\S4method{hm_mutate}{hydromet_compact}(obj, slot_name, FUN, ...)
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string with the a valid name.}

\item{FUN}{function name. The function output must be a data frame with
the first column being the \code{Date}. Note that \code{hydrotoolbox} provides common
used hydrological functions: see for example \link{mov_avg}. An interesting function to use is
\code{mutate} from \code{dplyr} package.}

\item{...}{\code{FUN} arguments to pass.}
}
\value{
The same object but with the modified slot's data frame
}
\description{
This method allows you to modify whatever (except \code{'date'} column)
you want inside a slot data frame. Since this package was designed with the aim of providing
useful objects to store and track changes in hydro-meteorological series, is not recommend
to delete or change the original data, but it is upon to you.
}
\section{Functions}{
\itemize{
\item \code{hm_mutate,hydromet_station-method}: method for station class.

\item \code{hm_mutate,hydromet_compact-method}: method for compact class.
}}

\examples{

# path to all example files
path <- system.file('extdata', package = 'hydrotoolbox')

# build the snih station file
guido <-
hm_create() \%>\%
  hm_build(bureau = 'snih', path = path,
           file_name = c('snih_hq_guido.xlsx',
           'snih_qd_guido.xlsx'),
           slot_name = c('hq', 'qd'),
           by = c('none', 'day') ) \%>\%
  hm_name(slot_name = 'qd',
          col_name = 'q(m3/s)')

 # apply a moving average windows to streamflow records
hm_mutate(obj = guido, slot_name = 'qd',
          FUN = mov_avg, k = 10,
          pos = 'c', out_name = 'mov_avg') \%>\%
 hm_plot(slot_name = 'qd',
         col_name = list(c('q(m3/s)', 'mov_avg') ),
         interactive = TRUE,
         line_color = c('dodgerblue', 'red3'),
         y_lab = 'Q(m3/s)',
         legend_lab = c('original', 'mov_avg')  )



}
