\name{skating}
\alias{skating}
\alias{skating_table}
\alias{skating_maxp}
\docType{data}
\title{Figure skating at the 2002 Winter Olympics}
\description{
  A likelihood function for the competitors at the Ladies' Free Skate
  at the 2002 Winter Olympics
}
\usage{data(skating)}
\details{

  There are three datasets loaded by \code{data("skating")}:
  \code{skating}, a log-likelihood function for the competitors'
  strengths, \code{skating_table}, an order table for each of the 9
  judges, and \code{skating_maxp}, the result of \code{maxp(skating)},
  which is included to save time in the examples.
    
  These objects can be generated by running script
  \code{inst/skating_analysis.Rmd}, which includes some further
  discussion and technical documentation.  The dataset is interesting
  because it has been analysed by many workers, including Lock and Lock,
  for consistency between the judges.

  Note that file is structured so that each competitor is a row, and
  each judge is a column.  Function \code{rank_likelihood()} requires a
  transpose of this to operate.

  Object \code{skating_table} is an order table, taken from Lock and
  Lock.  It corrects what appears to be an error in which judge 5 ranked
  both Butyrskaya and Kettunen 12; there is no 13.  Using EM, I reckon
  that Butyrskaya should be ranked twelfth and Kettunen thirteenth.

}
\references{
  \itemize{
    \item
    \url{https://en.wikipedia.org/wiki/Figure_skating_at_the_2002_Winter_Olympics#Full_results_2}
    \item Robin Lock and Kari Frazer Lock, Winter
    2003. \dQuote{Judging Figure Skating Judges}.  \emph{STATS 36}, ASA
  }
}
\author{Robin K. S. Hankin}
\examples{
data(skating)
dotchart(skating_maxp)

ordertable_to_ranktable(skating_table)

rL <- sort(skating_maxp,decreasing=TRUE)
rL[] <- seq_along(rL)
rO <- seq_len(nrow(skating_table))
names(rO) <- rownames(skating_table)
ordertransplot(rO,rL,
   xlab="official rank",ylab="likelihood rank",
   main="Ladies free skating, 2002 Winter Olympics")

}
\keyword{datasets}

