% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{as.hyperSpec}
\alias{as.hyperSpec}
\alias{as.hyperSpec,matrix-method}
\alias{as.hyperSpec,data.frame-method}
\title{as.hyperSpec: convenience conversion functions}
\usage{
as.hyperSpec(X, ...)

\S4method{as.hyperSpec}{matrix}(X, wl = guess.wavelength(colnames(X)), ...)

\S4method{as.hyperSpec}{data.frame}(
  X,
  spc = NULL,
  wl = guess.wavelength(spc),
  labels = attr(X, "labels"),
  ...
)
}
\arguments{
\item{X}{the object to convert.
A matrix is assumed to contain the spectra matrix,
a data.frame is assumed to contain extra data.}

\item{...}{additional parameters that should be handed over to \code{new ("hyperSpec")} (initialize)}

\item{wl}{wavelength vector. Defaults to guessing from the column names in \code{X}}

\item{spc}{spectra matrix}

\item{labels}{list with labels}
}
\value{
hyperSpec object
}
\description{
These functions are shortcuts to convert other objects into hypeSpec objects.
}
\note{
\emph{Note that the behaviour of \code{as.hyperSpec (X)} was changed: it now assumes \code{X} to be extra data,
and returns a hyperSpec object with 0 wavelengths. To get the old behaviour}
}
\examples{
tmp <- data.frame(flu [[,, 400 ~ 410]])
(wl <- colnames (tmp))
guess.wavelength (wl)
}
\seealso{
\code{\link[hyperSpec]{initialize}}
}
