% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hs_search.R
\name{hs_search}
\alias{hs_search}
\title{Search hypothes.is annotations}
\source{
\url{https://h.readthedocs.io/en/latest/api/#search}
}
\usage{
hs_search(limit = NULL, offset = NULL, sort = "updated", order = "asc",
  uri = NULL, user = NULL, text = NULL, any = NULL, custom = list())
}
\arguments{
\item{limit}{Integer. The maximum number of annotations to return. (Default:
20)}

\item{offset}{Integer The minimum number of initial annotations to skip. This
is used for pagination. For example if there are 65 annotations matching
our search query and we're retrieving up to 30 annotations at a time, then
to retrieve the last 5, set offset = 5. (Default = 0)}

\item{sort}{Character. Specify which field the annotations should be sorted
by: \code{consumer}, \code{created}, \code{id}, \code{text},
\code{updated}, \code{uri}, \code{user}.}

\item{order}{Character. Specify which order annotations should be sorted by:
\code{asc} or \code{desc}.}

\item{uri}{Character. Search for annotations of a particular URI, for example
\code{www.example.com}. URI searches will also find annotations of
equivalent URIs. For example if the HTML document at
\code{http://www.example.com/document.html?} includes a \code{<link
rel="canonical" href="http://www.example.com/canonical_document.html">}
then annotations of \code{http://www.example.com/canonical_document.html}
will also be included in the search results. Other forms of document
equivalence that are supported include \code{rel="alternate"} links, DOIs,
PDF file IDs, and more.}

\item{user}{Character. Search for annotations by a particular user. For
example, \code{tim} will find all annotations by users named \code{tim} at
any provider, while \code{tim@hypothes.is} will only find annotations by
\code{tim} on \code{hypothes.is}}

\item{text}{Character. Search for annotations whose body text contains some
text, for example: \code{foobar}.}

\item{any}{Character. Search for annotations whose \code{quote}, \code{tags},
\code{text}, \code{uri.parts} or \code{user} fields match some query text.}

\item{custom}{A named list of any field in the results returned by
hypothes.is as a name, and the search text as values.}
}
\value{
A dataframe with annotation data.
}
\description{
Search hypothes.is annotations.
}
\note{
If any vectors are passed to these arguments, only the first values
  will be used.
}
\examples{
# Search for no more than 5 annotations containing the text "ulysses"
hs_search(text = "ulysses", limit = 5)
# Search with a custom field for tags
hs_search(custom = list(tags = "todo"))
# use the 'uri.parts' field to find annotations on a given domain (exclude
# the TLD, as this will result in all annotations on sites with, e.g., .org,
# as well.)
hs_search(custom = list(uri.parts = "programminghistorian"))
}

