% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARkalman.R
\name{IAR.kalman}
\alias{IAR.kalman}
\title{Maximum Likelihood Estimation of the IAR Model via Kalman Recursions}
\usage{
IAR.kalman(y, sT, delta = 0, zero.mean = "TRUE", standarized = "TRUE")
}
\arguments{
\item{y}{Array with the time series observations.}

\item{sT}{Array with the irregular observational times.}

\item{delta}{Array with the measurements error standard deviations.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y is standarized; if false, y contains the raw time series}
}
\value{
A list with the following components:
\itemize{
\item{phi}{ MLE of the phi parameter of the IAR model.}
\item{ll}{ Value of the negative log likelihood evaluated in phi.}
}
}
\description{
Maximum Likelihood Estimation of the IAR model parameter phi. The estimation procedure uses the Kalman Filter to find the maximum of the likelihood.
}
\examples{
set.seed(6714)
st<-gentime(n=100)
y<-IAR.sample(phi=0.99,n=100,st)
y<-y$series
phi=IAR.kalman(y=y,sT=st)$phi
print(phi)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IAR.sample}}, \code{\link{arima}},\code{\link{IAR.phi.kalman}}
}
