% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F041.clono.plot.R
\name{clono.plot}
\alias{clono.plot}
\title{Make 2D and 3D scatter plots for clonotypes.}
\usage{
clono.plot(
  x = NULL,
  plot.data.type = "tsne",
  clono = 1,
  clust.dim = 2,
  cell.size = 1,
  cell.colors = c("red", "gray"),
  box.cell.col = "black",
  back.col = "white",
  cell.transparency = 0.5,
  interactive = TRUE,
  out.name = "plot"
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{plot.data.type}{Choose from "tsne" and "pca", default = "tsne".}

\item{clono}{A clonotype name to be plotted, default = 1.}

\item{clust.dim}{2 for 2D plots and 3 for 3D plots, default =  2.}

\item{cell.size}{A number for the size of the points in the plot, default = 1.}

\item{cell.colors}{Colors for heat mapping the points in "scatterplot", default = c("gray","red").}

\item{box.cell.col}{Choose a color for box default =  "black".}

\item{back.col}{A color for the plot background, default = "black".}

\item{cell.transparency}{Color transparency for points, default = 0.5.}

\item{interactive}{If set to TRUE an intractive HTML file will be created, default = TRUE.}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "plot".}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and provides plots for clonotypes.
}
