\name{ttsLSTM}
\alias{ttsLSTM}

\encoding{latin1}

\title{Train time series by LSTM of \code{tensorflow} provided by \code{kera}}

\description{
It generates  both the static and recursive time series plots of deep learning LSTM object generated by package \code{tensorflow} provided by \code{kera}.
}
\usage{
ttsLSTM(y,
  x=NULL,
  train.end,
  arOrder=1,
  xregOrder=0,
  type,
  memoryLoops=10,
  shape=NULL,
  dim3=5,
  batch.range=2:7,
  batch.size=NULL)
}

\arguments{
  \item{y}{
The time series object of the target variable, or the dependent variable,  with \code{timeSeries} or \code{zoo} format, must have dimension. y can be both continuous and discrete.Time format must be "%Y-%m-%d".
}

  \item{x}{ The time series matrix of input variables, or the independent variables,  with \code{timeSeries} or \code{zoo} format. Time format must be "%Y-%m-%d".
}


  \item{train.end}{The end date of training data, must be specificed.The default dates of train.start and test.end are the start and the end of input data; and the test.start is the 1-period next of train.end.

}

\item{arOrder}{The autoregressive order of the target variable, which may be sequentially specifed like arOrder=1:5; or discontinuous lags like arOrder=c(1,3,5); zero is not allowed.Default is 1.

}

\item{xregOrder}{The distributed lag structure of the input variables, which may be sequentially specifed like xregOrder=1:5; or discontinuous lags like xregOrder=c(0,3,5); zero is allowed since contemporaneous correlation is allowed.

}

\item{type}{The additional input variables. We have four selection:\cr "none"=no other variables,\cr "trend"=inclusion of time dummy, \cr "season"=inclusion of seasonal dummies, \cr "both"=inclusion of both trend and season. No default.

}

\item{memoryLoops}{Length of LSTM learning network loop, to achieve better learning results, this not is suggested to be the same as the length of data row. Default is 10.}.

\item{shape}{The second dmension of LSTM array. If NULL, then it will use the number of columns of complete dataset.}.

\item{dim3}{The third dmension of LSTM array. Default is 5.}.

\item{batch.range}{The range of search batch.size. The code selects the first that satisfies exact division with the rows of data used}.

\item{batch.size}{The number of batch size for LSTM layer. Default is NULL determined by searching among the batch.range.}.



}


\details{

This function calls the function fit of package \code{tensorflow} to execute Long-Short Term Memory (LSTM) estimation. When execution finished, it computes two types of time series forecasts: static and recursive.
}



\value{

  \item{output}{Output object generated by train function of \code{caret}.}
  \item{batch.size}{The batch.size used for LSTM network.}
  \item{k}{The third dimension of arrayin LSTM network.}
  \item{SHAPE}{The shape size  of array in LSTM network.}
  \item{arOrder}{he autoregressive order of the target variable used.}
  \item{data}{The dataset of used.}
  \item{dataused}{The data used by arOrder, xregOrder, and type}
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}

\examples{
# Cross-validation takes time, example below is commented.
data("macrodata")
dep<-macrodata[,"unrate",drop=FALSE]
ind<-macrodata[,-1,drop=FALSE]

# Choosing the dates of training and testing data
train.end<-"2008-12-01"


#RNN with LSTM network
#LSTM<-ttsLSTM(y=dep, x=ind, train.end,arOrder=c(2,4), xregOrder=c(1,4),
# memoryLoops=5, type=c("none","trend","season","both")[4],
# batch.range=2:7,batch.size=NULL)

#testData3<-window(LSTM$dataused,start="2009-01-01",end=end(LSTM$data))
#P1<-iForecast(Model=LSTM,newdata=testData3,type="static")
#P2<-iForecast(Model=LSTM,newdata=testData3,type="dynamic")

#tail(cbind(testData3[,1],P1,P2))



}

