% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_expand_when_stuck.R, R/gm_percolation.R
\name{graph_match_ExpandWhenStuck}
\alias{graph_match_ExpandWhenStuck}
\alias{graph_match_percolation}
\title{Percolation Graph Matching Methods}
\usage{
graph_match_ExpandWhenStuck(A, B, seeds, similarity = NULL, r = 2)

graph_match_percolation(A, B, seeds, similarity = NULL, r = 2)
}
\arguments{
\item{A}{A matrix, 'igraph' object, or list of either.}

\item{B}{A matrix, 'igraph' object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix
or a data frame, with the first column being the indices of \eqn{G_1} and
the second column being the corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similarities.}

\item{r}{A number. Threshold of neighboring pair scores.}
}
\value{
\code{graph_match_percolation} and \code{graph_match_ExpandWhenStuck}
  returns a list of graph matching results, including the graph matching formula,
  a data frame containing the matching correspondence between \eqn{G_1} and
  \eqn{G_2} named \code{corr_A} and \code{corr_B}, seeds and the order of nodes
  getting matched.
}
\description{
Percolation Graph Matching Methods
}
\examples{
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
# match G_1 & G_2 using Expand When Stuck graph matching method
seeds <- 1:5
graph_match_ExpandWhenStuck(g1, g2, seeds, r = 2)

# match G_1 & G_2 using percolation graph matching method
graph_match_percolation(g1, g2, seeds, r = 2)

}
\references{
E. Kazemi, S. H. Hassani, and M. Grossglauser (2015),
\emph{Growing a graph matching from a handful of seeds}. Proc. of the VLDB
Endowment, 8(10):1010–1021.

L. Yartseva and M. Grossglauser (2013), \emph{On the performance
  of percolation graph matching}. COSN, Boston, MA, USA, pages 119–130.
}
