% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_match_class.R
\name{as.data.frame,graphMatch-method}
\alias{as.data.frame,graphMatch-method}
\alias{show,graphMatch-method}
\alias{print,graphMatch-method}
\alias{[,graphMatch,missing,missing,missing-method}
\alias{dim,graphMatch-method}
\alias{length,graphMatch-method}
\alias{t,graphMatch-method}
\alias{rev,graphMatch-method}
\alias{[,graphMatch,ANY,ANY,ANY-method}
\alias{str,graphMatch-method}
\alias{$,graphMatch-method}
\title{Methods for the graphMatch class}
\usage{
\S4method{as.data.frame}{graphMatch}(x)

\S4method{show}{graphMatch}(object)

\S4method{print}{graphMatch}(x)

\S4method{[}{graphMatch,missing,missing,missing}(x, i = NULL, j = NULL, drop = NULL)

\S4method{dim}{graphMatch}(x)

\S4method{length}{graphMatch}(x)

\S4method{t}{graphMatch}(x)

\S4method{rev}{graphMatch}(x)

\S4method{[}{graphMatch,ANY,ANY,ANY}(x, i = NULL, j = NULL, drop = NULL)

\S4method{str}{graphMatch}(object)

\S4method{$}{graphMatch}(x, name)
}
\arguments{
\item{x}{graphMatch object}

\item{object}{graphMatch object}

\item{i}{row index for the correspondence data.frame}

\item{j}{col index for the correspondence data.frame}

\item{drop}{ignored}

\item{name}{name of element in the list}
}
\value{
\code{dim} returns a vector of length two indicating the number of
  vertices in each original graph. \code{length} returns the number of found
  vertex-pair matches. \code{m[i,j]} will index the 2 x length data.frame of
  vertex-pair matches. This is true for any i,j unless both are missing. In
  that case, \code{m[]} returns a sparse matrix of dimension dim(m) where
  \code{m[][i,j]} is 0 unless m matches node i with node j. (Note this is not
  guaranteed to be a permutation matrix unless \code{dim(m)[1] = dim(m)[2] =
  length(m)}.
}
\description{
These methods provide functionality to view, inspect, and
  convert \link{graphMatch} objects.
}
\details{
Methods for the graphMatch class
}
\examples{
# sample a pair of correlated random graphs from G(n,p)
set.seed(123)
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2

# match g1 & g2 using FW methodology with indefinite relaxation
match <- gm(A = g1, B = g2, seeds = 1:3, method = 'indefinite')

# print graphMatch object
match
print(match)
show(match)

# print matching correspondence
match$corr_A # matching correspondence in the first graph
match$corr_B # matching correspondence in the second graph

# get nonseed matching correspondence
match[!match$seeds]

# create graphMatch object from a vector
as.graphMatch(sample(10))
# or data.frame
as.graphMatch(data.frame(a = 1:10, b = sample(1000, 10)))

# get corresponding permutation matrix for the match result
match[] # preferred approach
# or equivalently
get_perm_mat(match)


# sizes of two graphs
dim(match)

# number of matched node pairs
length(match)


# reverse the matching correspondence between two graphs
t(match)
rev(match)
}
\seealso{
\link[iGraphMatch:plot,igraph,igraph-method]{graphMatch_plot}, \link[iGraphMatch:\%*\%,graphMatch,ANY-method]{graphMatch_operators}
}
\keyword{internal}
