/*
 * Decompiled with CFR 0.152.
 */
package mrmc.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mrmc.core.CovMRMC;
import mrmc.core.InputFile;
import mrmc.core.Matrix;
import mrmc.core.StatTest;
import mrmc.gui.GUInterface;
import mrmc.gui.SizePanel;

public class DBRecord {
    public boolean verbose = true;
    public double totalVarMLE;
    public double varAMLE = 0.0;
    public double varBMLE = 0.0;
    public double[] readerTotalVarMLE;
    public double[][] readerTotalCovMLE;
    public double[] readerVarAMLE;
    public double[] readerVarBMLE;
    public double[][] readerCovAMLE;
    public double[][] readerCovBMLE;
    public GUInterface GUI;
    public DBRecord DBRecordStat;
    public DBRecord DBRecordSize;
    public InputFile InputFile1;
    public SizePanel SizePanel1;
    public StatTest testStat;
    public StatTest testSize;
    public String filename = "";
    public String recordDesc = "";
    public String recordTitle = "";
    public String Task = "";
    public long Nreader = -1L;
    public long Nnormal = -1L;
    public long Ndisease = -1L;
    public long NreaderDB = -1L;
    public long NnormalDB = -1L;
    public long NdiseaseDB = -1L;
    public String modalityA = "modalityA";
    public String modalityB = "modalityB";
    public int selectedMod = 3;
    public CovMRMC covMRMCstat;
    public CovMRMC covMRMCsize;
    public double[] AUCsReaderAvg;
    public double[][] AUCs;
    public int[][] N0perReader;
    public int[][] N1perReader;
    public double totalVar = -1.0;
    public double SE = -1.0;
    public double varA = -1.0;
    public double varB = -1.0;
    public double[] readerTotalVar;
    public double[] readerVarA;
    public double[] readerVarB;
    public double[][] readerTotalCov;
    public double[][] readerCovA;
    public double[][] readerCovB;
    public int flagMLE = 0;
    public long flagTotalVarIsNegative = 0L;
    public boolean flagFullyCrossed = true;
    public NumberFormat formatter = new DecimalFormat("#0.00");
    public double[][] BDG = new double[4][8];
    public double[][] LoadBDG = new double[4][8];
    public double[][] BDGbias = new double[4][8];
    public double[][] BDGcoeff = new double[4][8];
    public static double[][] BDGresult = new double[4][8];
    public static double[][] BDGbiasresult = new double[4][8];
    public static double[][] BDGcoeffresult = new double[4][8];
    public static double[][] BDGPanelresult = new double[7][8];
    public double[][] BCKbias = new double[4][7];
    public double[][] BCK = new double[4][7];
    public double[][] BCKcoeff = new double[4][7];
    public static double[][] BCKresult = new double[4][7];
    public static double[][] BCKbiasresult = new double[4][7];
    public static double[][] BCKcoeffresult = new double[4][7];
    public static double[][] BCKPanelresult = new double[7][7];
    public double[][] DBMbias = new double[4][6];
    public double[][] DBM = new double[4][6];
    public double[][] DBMcoeff = new double[4][6];
    public static double[][] DBMresult = new double[4][6];
    public static double[][] DBMbiasresult = new double[4][6];
    public static double[][] DBMcoeffresult = new double[4][6];
    public static double[][] DBMPanelresult = new double[3][6];
    public double[][] ORbias = new double[4][6];
    public double[][] OR = new double[4][6];
    public double[][] ORcoeff = new double[4][6];
    public static double[][] ORbiasresult = new double[4][6];
    public static double[][] ORresult = new double[4][6];
    public static double[][] ORcoeffresult = new double[4][6];
    public static double[][] ORPanelresult = new double[3][6];
    public double ms_r;
    public double ms_rA;
    public double ms_rB;
    public double ms_t;
    public double ms_tA;
    public double ms_tB;
    public double ms_tr;
    public double ms_trA;
    public double ms_trB;
    public double[][] MS = new double[4][6];
    public double[][] MSbias = new double[4][6];
    public double[][] MScoeff = new double[4][6];
    public int inputMod;
    public static double[][] MSresult = new double[4][6];
    public static double[][] MSbiasresult = new double[4][6];
    public static double[][] MScoeffresult = new double[4][6];
    public static double[][] MSPanelresult = new double[3][6];

    public void resetDBRecord() {
        this.Nreader = -1L;
        this.Nnormal = -1L;
        this.Ndisease = -1L;
        this.NreaderDB = -1L;
        this.NnormalDB = -1L;
        this.NdiseaseDB = -1L;
        this.totalVar = -1.0;
        this.SE = -1.0;
        this.varA = -1.0;
        this.varB = -1.0;
        this.flagMLE = 0;
        this.flagTotalVarIsNegative = 0L;
        this.flagFullyCrossed = true;
        this.BDG = new double[4][8];
        this.LoadBDG = new double[4][8];
        this.BDGbias = new double[4][8];
        this.BDGcoeff = new double[4][8];
        BDGresult = new double[4][8];
        BDGbiasresult = new double[4][8];
        BDGcoeffresult = new double[4][8];
        BDGPanelresult = new double[7][8];
    }

    public DBRecord(GUInterface GUItemp) {
        this.GUI = GUItemp;
    }

    public DBRecord() {
    }

    public DBRecord(String fname, String[] componentStrings, ArrayList<String> desc, String AUCstr) {
        double x = 1 / 0;
    }

    public DBRecord(double[][] components, int whichComp, long n, long n2, long n3, double[] auc) {
        double x = 1 / 0;
    }

    public void DBRecordStatFill(InputFile InputFileTemp, DBRecord DBRecordStatTemp) {
        this.InputFile1 = InputFileTemp;
        this.DBRecordStat = DBRecordStatTemp;
        this.covMRMCstat = new CovMRMC(this.InputFile1, DBRecordStatTemp);
        this.BDGforStatPanel();
        this.Decompositions();
        TreeMap<String, TreeMap<String, ArrayList<String>>> modinformation1 = this.InputFile1.modinformation;
        ArrayList<Object> chosenreaderlist = new ArrayList();
        ArrayList<Object> chosennormallist = new ArrayList();
        ArrayList<Object> chosendiseaselist = new ArrayList();
        if (this.selectedMod == 0) {
            chosenreaderlist = modinformation1.get(this.modalityA).get("reader");
            chosennormallist = modinformation1.get(this.modalityA).get("normal");
            chosendiseaselist = modinformation1.get(this.modalityA).get("disease");
            if (this.AUCsReaderAvg[0] < 0.0) {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "There are no observations for modality A.\nPlease check your data.", "Error", 0);
                return;
            }
        }
        if (this.selectedMod == 1) {
            chosenreaderlist = modinformation1.get(this.modalityB).get("reader");
            chosennormallist = modinformation1.get(this.modalityB).get("normal");
            chosendiseaselist = modinformation1.get(this.modalityB).get("disease");
            if (this.AUCsReaderAvg[1] < 0.0) {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "There are no observations for modality B.\nPlease check your data.", "Error", 0);
                return;
            }
        }
        if (this.selectedMod == 3) {
            JFrame frame;
            for (String r : modinformation1.get(this.modalityA).get("reader")) {
                chosenreaderlist.add(r);
            }
            for (String nor : modinformation1.get(this.modalityA).get("normal")) {
                chosennormallist.add(nor);
            }
            for (String dis : modinformation1.get(this.modalityA).get("disease")) {
                chosendiseaselist.add(dis);
            }
            for (String r : modinformation1.get(this.modalityB).get("reader")) {
                if (chosenreaderlist.contains(r)) continue;
                chosenreaderlist.add(r);
            }
            for (String nor : modinformation1.get(this.modalityB).get("normal")) {
                if (chosennormallist.contains(nor)) continue;
                chosennormallist.add(nor);
            }
            for (String dis : modinformation1.get(this.modalityB).get("disease")) {
                if (chosendiseaselist.contains(dis)) continue;
                chosendiseaselist.add(dis);
            }
            if (this.AUCsReaderAvg[0] < 0.0) {
                frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "There are no observations for modality A.\nPlease check your data.", "Error", 0);
                return;
            }
            if (this.AUCsReaderAvg[1] < 0.0) {
                frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "There are no observations for modality B.\nPlease check your data.", "Error", 0);
                return;
            }
        }
        this.NreaderDB = chosenreaderlist.size();
        this.NnormalDB = chosennormallist.size();
        this.NdiseaseDB = chosendiseaselist.size();
        if (this.selectedMod == 0) {
            this.flagFullyCrossed = (long)this.covMRMCstat.totalscoredA == this.NreaderDB * (this.NnormalDB + this.NdiseaseDB);
        }
        if (this.selectedMod == 1) {
            this.flagFullyCrossed = (long)this.covMRMCstat.totalscoredB == this.NreaderDB * (this.NnormalDB + this.NdiseaseDB);
        }
        if (this.selectedMod == 3) {
            this.flagFullyCrossed = (long)this.covMRMCstat.totalscoredAB == this.NreaderDB * (this.NnormalDB + this.NdiseaseDB);
        }
        this.N0perReader = this.covMRMCstat.N0perReader;
        this.N1perReader = this.covMRMCstat.N1perReader;
        this.testStat = new StatTest(this.DBRecordStat);
    }

    public void DBRecordStatFillSummary(DBRecord dBRecordStat2) {
        this.DBRecordStat = dBRecordStat2;
        double NR = this.Nreader;
        double N0 = this.Nnormal;
        double N1 = this.Ndisease;
        double[][] unbiasToBias = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0 / N0, (N0 - 1.0) / N0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0 / N1, 0.0, (N1 - 1.0) / N1, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0 / N0 / N1, (N0 - 1.0) / N0 / N1, (N1 - 1.0) / N0 / N1, (N0 - 1.0) * (N1 - 1.0) / N0 / N1, 0.0, 0.0, 0.0, 0.0}, {1.0 / NR, 0.0, 0.0, 0.0, (NR - 1.0) / NR, 0.0, 0.0, 0.0}, {1.0 / N0 / NR, (N0 - 1.0) / N0 / NR, 0.0, 0.0, (NR - 1.0) / N0 / NR, (N0 - 1.0) * (NR - 1.0) / N0 / NR, 0.0, 0.0}, {1.0 / N1 / NR, 0.0, (N1 - 1.0) / N1 / NR, 0.0, (NR - 1.0) / N1 / NR, 0.0, (N1 - 1.0) * (NR - 1.0) / N1 / NR, 0.0}, {1.0 / N0 / N1 / NR, (N0 - 1.0) / N0 / N1 / NR, (N1 - 1.0) / N0 / N1 / NR, (N0 - 1.0) * (N1 - 1.0) / N0 / N1 / NR, (NR - 1.0) / N0 / N1 / NR, (N0 - 1.0) * (NR - 1.0) / N0 / N1 / NR, (N1 - 1.0) * (NR - 1.0) / N0 / N1 / NR, (N0 - 1.0) * (N1 - 1.0) * (NR - 1.0) / N0 / N1 / NR}};
        this.DBRecordStat.BDG = new double[4][8];
        if (this.selectedMod == 0) {
            this.DBRecordStat.BDG[0] = this.DBRecordStat.LoadBDG[0];
        } else if (this.selectedMod == 1) {
            this.DBRecordStat.BDG[1] = this.DBRecordStat.LoadBDG[1];
        } else if (this.selectedMod == 3) {
            this.DBRecordStat.BDG = this.DBRecordStat.LoadBDG;
        }
        double[][] unbiasToBiast = Matrix.matrixTranspose(unbiasToBias);
        this.BDGbias = Matrix.multiply(this.DBRecordStat.BDG, unbiasToBiast);
        double totalVarnoMLE = 0.0;
        double varAnoMLE = 0.0;
        double varBnoMLE = 0.0;
        double varAMLE = 0.0;
        double varBMLE = 0.0;
        this.totalVarMLE = 0.0;
        this.totalVar = 0.0;
        this.varA = 0.0;
        this.varB = 0.0;
        this.BDGcoeff = DBRecord.genBDGCoeff(this.DBRecordStat.Nreader, this.DBRecordStat.Nnormal, this.DBRecordStat.Ndisease);
        double[] temp = new double[8];
        int i = 0;
        while (i < 8) {
            temp[i] = 1.0;
            ++i;
        }
        this.DBRecordStat.BDGcoeff[3] = temp;
        i = 0;
        while (i < 8) {
            this.DBRecordStat.BDG[3][i] = this.DBRecordStat.BDG[0][i] * this.DBRecordStat.BDGcoeff[0][i] + this.DBRecordStat.BDG[1][i] * this.DBRecordStat.BDGcoeff[1][i] - 2.0 * (this.DBRecordStat.BDG[2][i] * this.DBRecordStat.BDGcoeff[2][i]);
            this.DBRecordStat.BDGbias[3][i] = this.DBRecordStat.BDGbias[0][i] * this.DBRecordStat.BDGcoeff[0][i] + this.DBRecordStat.BDGbias[1][i] * this.DBRecordStat.BDGcoeff[1][i] - 2.0 * (this.DBRecordStat.BDGbias[2][i] * this.DBRecordStat.BDGcoeff[2][i]);
            totalVarnoMLE += this.BDGcoeff[3][i] * this.BDG[3][i];
            this.totalVarMLE += this.BDGcoeff[3][i] * this.BDGbias[3][i];
            varAnoMLE += this.BDGcoeff[0][i] * this.BDG[0][i];
            varBnoMLE += this.BDGcoeff[1][i] * this.BDG[1][i];
            varAMLE += this.BDGcoeff[0][i] * this.BDGbias[0][i];
            varBMLE += this.BDGcoeff[1][i] * this.BDGbias[1][i];
            ++i;
        }
        if (this.flagMLE == 0) {
            this.totalVar = totalVarnoMLE;
            this.varA = varAnoMLE;
            this.varB = varBnoMLE;
        } else {
            this.totalVar = this.totalVarMLE;
            this.varA = varAMLE;
            this.varB = varBMLE;
        }
        this.SE = Math.sqrt(this.totalVar);
        if (this.totalVar < 0.0) {
            this.flagTotalVarIsNegative = 1L;
        }
        BDGresult = this.BDG;
        BDGcoeffresult = this.BDGcoeff;
        BDGbiasresult = this.BDGbias;
        this.DBRecordStat.Decompositions();
        this.DBRecordStat.testStat = new StatTest(this.DBRecordStat);
    }

    public boolean DBRecordSizeFill(SizePanel SizePanelTemp) {
        this.SizePanel1 = SizePanelTemp;
        this.DBRecordSize = this.GUI.DBRecordSize;
        this.DBRecordStat = this.GUI.DBRecordStat;
        if (this.DBRecordStat.totalVar <= 0.0) {
            JOptionPane.showMessageDialog(this.GUI.MRMCobject.getFrame(), "Must perform variance analysis first.", "Error", 0);
            return false;
        }
        this.covMRMCstat = this.DBRecordStat.covMRMCstat;
        this.Nreader = Integer.parseInt(this.SizePanel1.NreaderJTextField.getText());
        this.Nnormal = Integer.parseInt(this.SizePanel1.NnormalJTextField.getText());
        this.Ndisease = Integer.parseInt(this.SizePanel1.NdiseaseJTextField.getText());
        int Ngroup = Integer.parseInt(this.SizePanel1.NumSplitPlotsJTextField.getText());
        int Preader = this.SizePanel1.pairedReadersFlag;
        int Pnormal = this.SizePanel1.pairedNormalsFlag;
        int Pdisease = this.SizePanel1.pairedDiseasedFlag;
        double Subreader = (double)this.Nreader / (double)Ngroup / (2.0 - (double)Preader);
        double Subnormal = (double)this.Nnormal / (double)Ngroup / (2.0 - (double)Pnormal);
        double Subdisease = (double)this.Ndisease / (double)Ngroup / (2.0 - (double)Pdisease);
        if (Math.floor(Subreader) != Subreader) {
            JOptionPane.showMessageDialog(this.GUI.MRMCobject.getFrame(), "The sizing panel needs the number of readers \r\n to be evenly distributed into each modality and group", "Error", 0);
            return false;
        }
        if (Math.floor(Subnormal) != Subnormal) {
            JOptionPane.showMessageDialog(this.GUI.MRMCobject.getFrame(), "The sizing panel needs the number of normal cases \r\n to be evenly distributed into each modality and group", "Error", 0);
            return false;
        }
        if (Math.floor(Subdisease) != Subdisease) {
            JOptionPane.showMessageDialog(this.GUI.MRMCobject.getFrame(), "The sizing panel needs the number of disease cases \r\n to be evenly distributed into each modality and group", "Error", 0);
            return false;
        }
        this.BDGcoeff = DBRecord.genBDGSplitUnpairedCoeff(this.Nreader, this.Nnormal, this.Ndisease, Ngroup, Preader, Pnormal, Pdisease);
        this.BDGforSizePanel();
        this.BCKcoeff = DBRecord.genBCKCoeff(this.BDGcoeff);
        this.BCK = DBRecord.BDG2BCK(this.BDG, this.BCKcoeff);
        this.BCKbias = DBRecord.BDG2BCK(this.BDGbias, this.BCKcoeff);
        BCKresult = this.BCK;
        BCKcoeffresult = this.BCKcoeff;
        BCKbiasresult = this.BCKbias;
        this.flagFullyCrossed = Ngroup == 1 && Preader == 1 && Pnormal == 1 && Pdisease == 1;
        this.testSize = new StatTest(this.SizePanel1, this.DBRecordStat, this.DBRecordSize);
        return true;
    }

    public double[] DBRecordSizeValidation(DBRecord DBRecordTrial, int Nreader, int Nnormal, int Ndisease, int Ngroup, int Preader, int Pnormal, int Pdisease) {
        SizePanel SizePanel1 = new SizePanel();
        SizePanel1.sigLevel = 0.05;
        SizePanel1.effSize = DBRecordTrial.AUCsReaderAvg[0] - DBRecordTrial.AUCsReaderAvg[1];
        this.DBRecordSize = DBRecordTrial;
        this.DBRecordStat = DBRecordTrial;
        this.BDGcoeff = DBRecord.genBDGSplitUnpairedCoeff(Nreader, Nnormal, Ndisease, Ngroup, Preader, Pnormal, Pdisease);
        this.BDGforSizePanel();
        this.BCKcoeff = DBRecord.genBCKCoeff(this.BDGcoeff);
        this.BCK = DBRecord.BDG2BCK(this.BDG, this.BCKcoeff);
        this.BCKbias = DBRecord.BDG2BCK(this.BDGbias, this.BCKcoeff);
        BCKresult = this.BCK;
        BCKcoeffresult = this.BCKcoeff;
        BCKbiasresult = this.BCKbias;
        this.flagFullyCrossed = Ngroup == 1 && Preader == 1 && Pnormal == 1 && Pdisease == 1;
        this.testSize = new StatTest(SizePanel1, this.DBRecordStat, this.DBRecordSize);
        double[] sizingresult = new double[]{Nreader, Nnormal, Ndisease, Ngroup, Preader, Pnormal, Pdisease, this.testSize.powerNormal, this.testSize.DF_BDG, this.DBRecordSize.SE, this.testSize.powerBDG, this.testSize.DF_Hillis, this.testSize.powerHillis};
        return sizingresult;
    }

    public void DBRecordRoeMetzNumericalFill(SizePanel SizePanelRoeMetz) {
        DBRecord DBRecordTemp = new DBRecord();
        this.covMRMCsize = new CovMRMC(SizePanelRoeMetz, DBRecordTemp);
        this.totalVar = 0.0;
        this.varA = 0.0;
        this.varB = 0.0;
        int i = 0;
        while (i < 8) {
            this.BDGcoeff[0][i] = this.covMRMCsize.coefficientsAA[i + 1];
            this.BDGcoeff[1][i] = this.covMRMCsize.coefficientsBB[i + 1];
            this.BDGcoeff[2][i] = this.covMRMCsize.coefficientsAB[i + 1];
            this.BDGcoeff[3][i] = 1.0;
            this.BDG[3][i] = this.BDGcoeff[0][i] * this.BDG[0][i] + this.BDGcoeff[1][i] * this.BDG[1][i] - 2.0 * this.BDGcoeff[2][i] * this.BDG[2][i];
            this.varA += this.BDGcoeff[0][i] * this.BDG[0][i];
            this.varB += this.BDGcoeff[1][i] * this.BDG[1][i];
            this.totalVar += this.BDGcoeff[3][i] * this.BDG[3][i];
            this.BDGbias[0][i] = this.BDG[0][i];
            this.BDGbias[1][i] = this.BDG[1][i];
            this.BDGbias[2][i] = this.BDG[2][i];
            this.BDGbias[3][i] = this.BDG[3][i];
            ++i;
        }
        this.SE = Math.sqrt(this.totalVar);
        double[][] readerBDG = new double[4][4];
        double[][] readerBDGcoeff = new double[4][4];
        this.N0perReader = new int[(int)this.Nreader][3];
        this.N1perReader = new int[(int)this.Nreader][3];
        this.readerTotalVar = new double[(int)this.Nreader];
        this.readerVarA = new double[(int)this.Nreader];
        this.readerVarB = new double[(int)this.Nreader];
        int ir = 0;
        while ((long)ir < this.Nreader) {
            this.N0perReader[ir][0] = this.covMRMCsize.N0perReader[0][0];
            this.N0perReader[ir][1] = this.covMRMCsize.N0perReader[0][1];
            this.N0perReader[ir][2] = this.covMRMCsize.N0perReader[0][2];
            this.N1perReader[ir][0] = this.covMRMCsize.N1perReader[0][0];
            this.N1perReader[ir][1] = this.covMRMCsize.N1perReader[0][1];
            this.N1perReader[ir][2] = this.covMRMCsize.N1perReader[0][2];
            int i2 = 0;
            while (i2 < 4) {
                readerBDG[0][i2] = this.BDG[0][i2];
                readerBDG[1][i2] = this.BDG[1][i2];
                readerBDG[2][i2] = this.BDG[2][i2];
                readerBDGcoeff[0][i2] = this.covMRMCsize.readerCoefficientsAA[ir][i2 + 1];
                readerBDGcoeff[1][i2] = this.covMRMCsize.readerCoefficientsBB[ir][i2 + 1];
                readerBDGcoeff[2][i2] = this.covMRMCsize.readerCoefficientsAB[ir][i2 + 1];
                readerBDGcoeff[3][i2] = 1.0;
                int n = ir;
                this.readerVarA[n] = this.readerVarA[n] + readerBDGcoeff[0][i2] * readerBDG[0][i2];
                int n2 = ir;
                this.readerVarB[n2] = this.readerVarB[n2] + readerBDGcoeff[1][i2] * readerBDG[1][i2];
                readerBDG[3][i2] = readerBDG[0][i2] * readerBDGcoeff[0][i2] + readerBDG[1][i2] * readerBDGcoeff[1][i2] - 2.0 * (readerBDG[2][i2] * readerBDGcoeff[2][i2]);
                int n3 = ir;
                this.readerTotalVar[n3] = this.readerTotalVar[n3] + readerBDGcoeff[3][i2] * readerBDG[3][i2];
                ++i2;
            }
            ++ir;
        }
        if (this.selectedMod == 0) {
            this.flagFullyCrossed = this.covMRMCsize.fullyCrossedA;
        }
        if (this.selectedMod == 1) {
            this.flagFullyCrossed = this.covMRMCsize.fullyCrossedB;
        }
        if (this.selectedMod == 3) {
            this.flagFullyCrossed = this.covMRMCsize.fullyCrossedA && this.covMRMCsize.fullyCrossedB && this.covMRMCsize.fullyCrossedAB;
        }
        this.Decompositions();
        this.testStat = new StatTest(this);
    }

    private void BDGforStatPanel() {
        double totalVarnoMLE = 0.0;
        double varAnoMLE = 0.0;
        double varBnoMLE = 0.0;
        this.varAMLE = 0.0;
        this.varBMLE = 0.0;
        double[] readerTotalVarnoMLE = new double[(int)this.Nreader];
        double[][] readerTotalCovnoMLE = new double[(int)this.Nreader][(int)this.Nreader];
        this.readerTotalVarMLE = new double[(int)this.Nreader];
        this.readerTotalCovMLE = new double[(int)this.Nreader][(int)this.Nreader];
        double[] readerVarAnoMLE = new double[(int)this.Nreader];
        double[] readerVarBnoMLE = new double[(int)this.Nreader];
        double[][] readerCovAnoMLE = new double[(int)this.Nreader][(int)this.Nreader];
        double[][] readerCovBnoMLE = new double[(int)this.Nreader][(int)this.Nreader];
        this.readerVarAMLE = new double[(int)this.Nreader];
        this.readerVarBMLE = new double[(int)this.Nreader];
        this.readerCovAMLE = new double[(int)this.Nreader][(int)this.Nreader];
        this.readerCovBMLE = new double[(int)this.Nreader][(int)this.Nreader];
        this.readerTotalVar = new double[(int)this.Nreader];
        this.readerVarA = new double[(int)this.Nreader];
        this.readerVarB = new double[(int)this.Nreader];
        this.totalVarMLE = 0.0;
        int i = 0;
        while (i < 8) {
            this.BDG[0][i] = this.covMRMCstat.momentsAA[i + 1];
            this.BDG[1][i] = this.covMRMCstat.momentsBB[i + 1];
            this.BDG[2][i] = this.covMRMCstat.momentsAB[i + 1];
            this.BDGbias[0][i] = this.covMRMCstat.momentsBiasedAA[i + 1];
            this.BDGbias[1][i] = this.covMRMCstat.momentsBiasedBB[i + 1];
            this.BDGbias[2][i] = this.covMRMCstat.momentsBiasedAB[i + 1];
            this.BDGcoeff[0][i] = this.covMRMCstat.coefficientsAA[i + 1];
            this.BDGcoeff[1][i] = this.covMRMCstat.coefficientsBB[i + 1];
            this.BDGcoeff[2][i] = this.covMRMCstat.coefficientsAB[i + 1];
            varAnoMLE += this.BDGcoeff[0][i] * this.BDG[0][i];
            varBnoMLE += this.BDGcoeff[1][i] * this.BDG[1][i];
            this.varAMLE += this.BDGcoeff[0][i] * this.BDGbias[0][i];
            this.varBMLE += this.BDGcoeff[1][i] * this.BDGbias[1][i];
            this.BDGcoeff[3][i] = 1.0;
            this.BDG[3][i] = this.BDG[0][i] * this.BDGcoeff[0][i] + this.BDG[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDG[2][i] * this.BDGcoeff[2][i]);
            this.BDGbias[3][i] = this.BDGbias[0][i] * this.BDGcoeff[0][i] + this.BDGbias[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDGbias[2][i] * this.BDGcoeff[2][i]);
            totalVarnoMLE += this.BDGcoeff[3][i] * this.BDG[3][i];
            this.totalVarMLE += this.BDGcoeff[3][i] * this.BDGbias[3][i];
            ++i;
        }
        double[][] readerBDG = new double[4][4];
        double[][] readerBDGbias = new double[4][4];
        double[][] readerBDGcoeff = new double[4][4];
        double[][] readerBDGCov = new double[4][4];
        double[][] readerBDGbiasCov = new double[4][4];
        double[][] readerBDGcoeffCov = new double[4][4];
        int ir = 0;
        while ((long)ir < this.Nreader) {
            int i2 = 0;
            while (i2 < 4) {
                readerBDG[0][i2] = this.covMRMCstat.readerMomentsAA[ir][i2 + 1];
                readerBDG[1][i2] = this.covMRMCstat.readerMomentsBB[ir][i2 + 1];
                readerBDG[2][i2] = this.covMRMCstat.readerMomentsAB[ir][i2 + 1];
                readerBDGbias[0][i2] = this.covMRMCstat.readerMomentsBiasedAA[ir][i2 + 1];
                readerBDGbias[1][i2] = this.covMRMCstat.readerMomentsBiasedBB[ir][i2 + 1];
                readerBDGbias[2][i2] = this.covMRMCstat.readerMomentsBiasedAB[ir][i2 + 1];
                readerBDGcoeff[0][i2] = this.covMRMCstat.readerCoefficientsAA[ir][i2 + 1];
                readerBDGcoeff[1][i2] = this.covMRMCstat.readerCoefficientsBB[ir][i2 + 1];
                readerBDGcoeff[2][i2] = this.covMRMCstat.readerCoefficientsAB[ir][i2 + 1];
                readerBDGcoeff[3][i2] = 1.0;
                int n = ir;
                readerVarAnoMLE[n] = readerVarAnoMLE[n] + readerBDGcoeff[0][i2] * readerBDG[0][i2];
                int n2 = ir;
                readerVarBnoMLE[n2] = readerVarBnoMLE[n2] + readerBDGcoeff[1][i2] * readerBDG[1][i2];
                int n3 = ir;
                this.readerVarAMLE[n3] = this.readerVarAMLE[n3] + readerBDGcoeff[0][i2] * readerBDGbias[0][i2];
                int n4 = ir;
                this.readerVarBMLE[n4] = this.readerVarBMLE[n4] + readerBDGcoeff[1][i2] * readerBDGbias[1][i2];
                readerBDG[3][i2] = readerBDG[0][i2] * readerBDGcoeff[0][i2] + readerBDG[1][i2] * readerBDGcoeff[1][i2] - 2.0 * (readerBDG[2][i2] * readerBDGcoeff[2][i2]);
                readerBDGbias[3][i2] = readerBDGbias[0][i2] * readerBDGcoeff[0][i2] + readerBDGbias[1][i2] * readerBDGcoeff[1][i2] - 2.0 * (readerBDGbias[2][i2] * readerBDGcoeff[2][i2]);
                int n5 = ir;
                readerTotalVarnoMLE[n5] = readerTotalVarnoMLE[n5] + readerBDGcoeff[3][i2] * readerBDG[3][i2];
                int n6 = ir;
                this.readerTotalVarMLE[n6] = this.readerTotalVarMLE[n6] + readerBDGcoeff[3][i2] * readerBDGbias[3][i2];
                ++i2;
            }
            if (!Double.isNaN(readerVarAnoMLE[ir])) {
                readerVarAnoMLE[ir] = new BigDecimal(readerVarAnoMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            if (!Double.isNaN(readerVarBnoMLE[ir])) {
                readerVarBnoMLE[ir] = new BigDecimal(readerVarBnoMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            if (!Double.isNaN(this.readerVarAMLE[ir])) {
                this.readerVarAMLE[ir] = new BigDecimal(this.readerVarAMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            if (!Double.isNaN(this.readerVarBMLE[ir])) {
                this.readerVarBMLE[ir] = new BigDecimal(this.readerVarBMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            if (!Double.isNaN(readerTotalVarnoMLE[ir])) {
                readerTotalVarnoMLE[ir] = new BigDecimal(readerTotalVarnoMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            if (!Double.isNaN(this.readerTotalVarMLE[ir])) {
                this.readerTotalVarMLE[ir] = new BigDecimal(this.readerTotalVarMLE[ir]).setScale(8, RoundingMode.HALF_UP).doubleValue();
            }
            int irc = 0;
            while ((long)irc < this.Nreader) {
                int i3 = 0;
                while (i3 < 4) {
                    readerBDGCov[0][i3] = this.covMRMCstat.readerMomentsAACov[ir][irc][i3 + 1];
                    readerBDGCov[1][i3] = this.covMRMCstat.readerMomentsBBCov[ir][irc][i3 + 1];
                    readerBDGCov[2][i3] = this.covMRMCstat.readerMomentsABCov[ir][irc][i3 + 1];
                    readerBDGbiasCov[0][i3] = this.covMRMCstat.readerMomentsBiasedAACov[ir][irc][i3 + 1];
                    readerBDGbiasCov[1][i3] = this.covMRMCstat.readerMomentsBiasedBBCov[ir][irc][i3 + 1];
                    readerBDGbiasCov[2][i3] = this.covMRMCstat.readerMomentsBiasedABCov[ir][irc][i3 + 1];
                    readerBDGcoeffCov[0][i3] = this.covMRMCstat.readerCoefficientsAACov[ir][irc][i3 + 1];
                    readerBDGcoeffCov[1][i3] = this.covMRMCstat.readerCoefficientsBBCov[ir][irc][i3 + 1];
                    readerBDGcoeffCov[2][i3] = this.covMRMCstat.readerCoefficientsABCov[ir][irc][i3 + 1];
                    readerBDGcoeffCov[3][i3] = 1.0;
                    double[] dArray = readerCovAnoMLE[ir];
                    int n = irc;
                    dArray[n] = dArray[n] + readerBDGcoeffCov[0][i3] * readerBDGCov[0][i3];
                    double[] dArray2 = readerCovBnoMLE[ir];
                    int n7 = irc;
                    dArray2[n7] = dArray2[n7] + readerBDGcoeffCov[1][i3] * readerBDGCov[1][i3];
                    double[] dArray3 = readerTotalCovnoMLE[ir];
                    int n8 = irc;
                    dArray3[n8] = dArray3[n8] + readerBDGcoeffCov[2][i3] * readerBDGCov[2][i3];
                    double[] dArray4 = this.readerCovAMLE[ir];
                    int n9 = irc;
                    dArray4[n9] = dArray4[n9] + readerBDGcoeffCov[0][i3] * readerBDGbiasCov[0][i3];
                    double[] dArray5 = this.readerCovBMLE[ir];
                    int n10 = irc;
                    dArray5[n10] = dArray5[n10] + readerBDGcoeffCov[1][i3] * readerBDGbiasCov[1][i3];
                    double[] dArray6 = this.readerTotalCovMLE[ir];
                    int n11 = irc;
                    dArray6[n11] = dArray6[n11] + readerBDGcoeffCov[2][i3] * readerBDGbiasCov[2][i3];
                    ++i3;
                }
                ++irc;
            }
            ++ir;
        }
        if (this.flagMLE == 0) {
            this.totalVar = totalVarnoMLE;
            this.varA = varAnoMLE;
            this.varB = varBnoMLE;
            this.readerTotalVar = readerTotalVarnoMLE;
            this.readerVarA = readerVarAnoMLE;
            this.readerVarB = readerVarBnoMLE;
            this.readerCovA = readerCovAnoMLE;
            this.readerCovB = readerCovBnoMLE;
            this.readerTotalCov = readerTotalCovnoMLE;
        } else {
            this.totalVar = this.totalVarMLE;
            this.varA = this.varAMLE;
            this.varB = this.varBMLE;
            this.readerTotalVar = this.readerTotalVarMLE;
            this.readerVarA = this.readerVarAMLE;
            this.readerVarB = this.readerVarBMLE;
            this.readerCovA = this.readerCovAMLE;
            this.readerCovB = this.readerCovBMLE;
            this.readerTotalCov = this.readerTotalCovMLE;
        }
        this.SE = Math.sqrt(this.totalVar);
        if (this.totalVar < 0.0) {
            this.flagTotalVarIsNegative = 1L;
        }
        BDGresult = this.BDG;
        BDGcoeffresult = this.BDGcoeff;
        BDGbiasresult = this.BDGbias;
    }

    private void BDGforSizePanel() {
        this.totalVar = 0.0;
        this.totalVarMLE = 0.0;
        this.varA = 0.0;
        this.varB = 0.0;
        int i = 0;
        while (i < 8) {
            this.BDG[0][i] = this.DBRecordStat.BDG[0][i];
            this.BDG[1][i] = this.DBRecordStat.BDG[1][i];
            this.BDG[2][i] = this.DBRecordStat.BDG[2][i];
            this.BDGbias[0][i] = this.DBRecordStat.BDGbias[0][i];
            this.BDGbias[1][i] = this.DBRecordStat.BDGbias[1][i];
            this.BDGbias[2][i] = this.DBRecordStat.BDGbias[2][i];
            this.varA += this.BDGcoeff[0][i] * this.BDG[0][i];
            this.varB += this.BDGcoeff[1][i] * this.BDG[1][i];
            this.BDG[3][i] = this.BDG[0][i] * this.BDGcoeff[0][i] + this.BDG[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDG[2][i] * this.BDGcoeff[2][i]);
            this.BDGbias[3][i] = this.BDGbias[0][i] * this.BDGcoeff[0][i] + this.BDGbias[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDGbias[2][i] * this.BDGcoeff[2][i]);
            this.totalVar += this.BDGcoeff[3][i] * this.BDG[3][i];
            this.totalVarMLE += this.BDGcoeff[3][i] * this.BDGbias[3][i];
            ++i;
        }
        if (this.flagMLE == 1) {
            this.totalVar = this.totalVarMLE;
        }
        this.totalVar *= 1.0;
        this.SE = Math.sqrt(this.totalVar);
    }

    public void BDGforSizeFullPanel() {
        this.totalVar = 0.0;
        int i = 0;
        while (i < 8) {
            this.BDG[0][i] = this.DBRecordStat.BDG[0][i];
            this.BDG[1][i] = this.DBRecordStat.BDG[1][i];
            this.BDG[2][i] = this.DBRecordStat.BDG[2][i];
            this.BDGbias[0][i] = this.DBRecordStat.BDGbias[0][i];
            this.BDGbias[1][i] = this.DBRecordStat.BDGbias[1][i];
            this.BDGbias[2][i] = this.DBRecordStat.BDGbias[2][i];
            this.BDG[3][i] = this.BDG[0][i] * this.BDGcoeff[0][i] + this.BDG[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDG[2][i] * this.BDGcoeff[2][i]);
            this.BDGbias[3][i] = this.BDGbias[0][i] * this.BDGcoeff[0][i] + this.BDGbias[1][i] * this.BDGcoeff[1][i] - 2.0 * (this.BDGbias[2][i] * this.BDGcoeff[2][i]);
            this.totalVar += this.BDGcoeff[3][i] * this.BDG[3][i];
            ++i;
        }
        this.totalVar *= 1.0;
        this.SE = Math.sqrt(this.totalVar);
    }

    public void Decompositions() {
        this.BCKcoeff = DBRecord.genBCKCoeff(this.BDGcoeff);
        this.BCK = DBRecord.BDG2BCK(this.BDG, this.BCKcoeff);
        this.BCKbias = DBRecord.BDG2BCK(this.BDGbias, this.BCKcoeff);
        if (this.flagFullyCrossed) {
            this.DBMcoeff = DBRecord.genDBMCoeff(this.Nreader, this.Nnormal, this.Ndisease);
            this.ORcoeff = DBRecord.genORCoeff(this.Nreader, this.Nnormal, this.Ndisease);
            this.MScoeff = DBRecord.genMSCoeff(this.Nreader, this.Nnormal, this.Ndisease);
            this.DBM = DBRecord.BCK2DBM(this.BCK, this.Nreader, this.Nnormal, this.Ndisease);
            this.BDG2OR();
            this.MS = DBRecord.DBM2MS(this.DBM, this.Nreader, this.Nnormal, this.Ndisease);
            this.DBMbias = DBRecord.BCK2DBM(this.BCKbias, this.Nreader, this.Nnormal, this.Ndisease);
            this.ORbias = DBRecord.DBM2OR(0, this.DBMbias, this.Nreader, this.Nnormal, this.Ndisease);
            this.MSbias = DBRecord.DBM2MS(this.DBMbias, this.Nreader, this.Nnormal, this.Ndisease);
            DBMresult = this.DBM;
            DBMcoeffresult = this.DBMcoeff;
            DBMbiasresult = this.DBMbias;
            ORresult = this.OR;
            ORcoeffresult = this.ORcoeff;
            ORbiasresult = this.ORbias;
            MSresult = this.MS;
            MScoeffresult = this.MScoeff;
            MSbiasresult = this.MSbias;
        }
        BCKresult = this.BCK;
        BCKcoeffresult = this.BCKcoeff;
        BCKbiasresult = this.BCKbias;
    }

    public String getAUCsReaderAvgString(int selectedMod) {
        DecimalFormat threeDec = new DecimalFormat("0.000");
        threeDec.setGroupingUsed(false);
        String temp = "";
        switch (selectedMod) {
            case 0: {
                temp = "AUC_A = " + threeDec.format(this.AUCsReaderAvg[0]);
                break;
            }
            case 1: {
                temp = "AUC_B = " + threeDec.format(this.AUCsReaderAvg[1]);
                break;
            }
            case 3: {
                temp = "AUC_A = " + threeDec.format(this.AUCsReaderAvg[0]) + ",   AUC_B = " + threeDec.format(this.AUCsReaderAvg[1]) + ",   AUC_A - AUC_B = " + threeDec.format(this.AUCsReaderAvg[0] - this.AUCsReaderAvg[1]);
            }
        }
        return temp;
    }

    public double getAUCinNumber(int whichMod) {
        return this.AUCsReaderAvg[whichMod];
    }

    public String getSizes() {
        return String.valueOf(Long.toString(this.NreaderDB)) + " Readers,   " + Long.toString(this.NnormalDB) + " Normal cases,   " + Long.toString(this.NdiseaseDB) + " Disease cases.";
    }

    public long[] getSizesInt() {
        long[] c = new long[]{this.Nreader, this.Nnormal, this.Ndisease};
        return c;
    }

    public static double[][] getBDGTab(int selectedMod, double[][] BDGtemp, double[][] BDGc) {
        double[][] BDGTab1 = new double[7][8];
        if (selectedMod == 0) {
            BDGTab1[0] = BDGtemp[0];
            BDGTab1[1] = BDGc[0];
        } else if (selectedMod == 1) {
            BDGTab1[2] = BDGtemp[1];
            BDGTab1[3] = BDGc[1];
        } else if (selectedMod == 3) {
            BDGTab1[0] = BDGtemp[0];
            BDGTab1[1] = BDGc[0];
            BDGTab1[2] = BDGtemp[1];
            BDGTab1[3] = BDGc[1];
            BDGTab1[4] = BDGtemp[2];
            BDGTab1[5] = Matrix.scale(BDGc[2], 2.0);
        }
        int i = 0;
        while (i < 8) {
            BDGTab1[6][i] = BDGTab1[0][i] * BDGTab1[1][i] + BDGTab1[2][i] * BDGTab1[3][i] - BDGTab1[4][i] * BDGTab1[5][i];
            ++i;
        }
        BDGPanelresult = BDGTab1;
        return BDGTab1;
    }

    public static double[][] getDBMTab(int selectedMod, double[][] DBMtemp, double[][] DBMc) {
        double[][] DBMTab1 = new double[3][6];
        DBMTab1[0] = DBMtemp[selectedMod];
        DBMTab1[1] = DBMc[selectedMod];
        DBMTab1[2] = Matrix.dotProduct(DBMTab1[0], DBMTab1[1]);
        DBMPanelresult = DBMTab1;
        return DBMTab1;
    }

    public static double[][] getBCKTab(int selectedMod, double[][] BCKtemp, double[][] BCKc) {
        double[][] BCKTab1 = new double[7][7];
        if (selectedMod == 0) {
            BCKTab1[0] = BCKtemp[0];
            BCKTab1[1] = BCKc[0];
        } else if (selectedMod == 1) {
            BCKTab1[2] = BCKtemp[1];
            BCKTab1[3] = BCKc[1];
        } else if (selectedMod == 3) {
            BCKTab1[0] = BCKtemp[0];
            BCKTab1[1] = BCKc[0];
            BCKTab1[2] = BCKtemp[1];
            BCKTab1[3] = BCKc[1];
            BCKTab1[4] = BCKtemp[2];
            BCKTab1[5] = Matrix.scale(BCKc[2], 2.0);
        }
        int i = 0;
        while (i < 7) {
            BCKTab1[6][i] = BCKTab1[0][i] * BCKTab1[1][i] + BCKTab1[2][i] * BCKTab1[3][i] - BCKTab1[4][i] * BCKTab1[5][i];
            ++i;
        }
        BCKPanelresult = BCKTab1;
        return BCKTab1;
    }

    public static double[][] getORTab(int selectedMod, double[][] ORtemp, double[][] ORc) {
        double[][] ORTab1 = new double[3][6];
        ORTab1[0] = ORtemp[selectedMod];
        ORTab1[1] = ORc[selectedMod];
        ORTab1[2] = Matrix.dotProduct(ORTab1[0], ORTab1[1]);
        ORPanelresult = ORTab1;
        return ORTab1;
    }

    public static double[][] getMSTab(int selectedMod, double[][] MStemp, double[][] MSc) {
        double[][] MSTab1 = new double[3][6];
        MSTab1[0] = MStemp[selectedMod];
        MSTab1[1] = MSc[selectedMod];
        MSTab1[2] = Matrix.dotProduct(MSTab1[0], MSTab1[1]);
        MSPanelresult = MSTab1;
        return MSTab1;
    }

    public static double[][] DBM2MS(double[][] DBM, long Nreader2, long Nnormal2, long Ndisease2) {
        int j;
        double[][] c = new double[4][6];
        double[][] BAlpha = new double[][]{{2L * (Nnormal2 + Ndisease2), 0.0, 2.0, Nnormal2 + Ndisease2, 0.0, 1.0}, {0.0, 2L * Nreader2, 2.0, 0.0, Nreader2, 1.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, Nnormal2 + Ndisease2, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, Nreader2, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 6) {
                c[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        c = Matrix.matrixTranspose(Matrix.multiply((double[][])BAlpha, Matrix.matrixTranspose(DBM)));
        i = 0;
        while (i < 2) {
            j = 0;
            while (j < 6) {
                c[i][j] = c[i][j] / 2.0;
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static double[][] BCK2DBM(double[][] BCK, long Nreader2, long Nnormal2, long Ndisease2) {
        double[] c = new double[7];
        double[][] tmp = new double[4][7];
        double[][] tmp1 = new double[4][3];
        double[][] results = new double[4][6];
        c[0] = 1.0 / (double)Nnormal2;
        c[1] = 1.0 / (double)Ndisease2;
        c[2] = 1.0 / (double)(Nnormal2 * Ndisease2);
        c[3] = 1.0 / (double)Nreader2;
        c[4] = 1.0 / (double)(Nnormal2 * Nreader2);
        c[5] = 1.0 / (double)(Ndisease2 * Nreader2);
        c[6] = 1.0 / (double)(Nnormal2 * Ndisease2 * Nreader2);
        int i = 0;
        while (i < 3) {
            tmp[i] = Matrix.dotProduct(BCK[i], c);
            ++i;
        }
        double[][] alpha = new double[][]{{0.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {Nreader2, 0.0, 0.0}, {0.0, 0.0, Nreader2}, {0.0, 0.0, Nreader2}, {0.0, 0.0, Nreader2}};
        tmp1 = Matrix.multiply(tmp, alpha);
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 6) {
                results[i2][j] = 0.0;
                ++j;
            }
            ++i2;
        }
        results[0][0] = tmp1[0][0];
        results[0][1] = tmp1[0][1] * (double)(Nnormal2 + Ndisease2);
        results[0][2] = tmp1[0][2] * (double)(Nnormal2 + Ndisease2);
        results[1][0] = tmp1[1][0];
        results[1][1] = tmp1[1][1] * (double)(Nnormal2 + Ndisease2);
        results[1][2] = tmp1[1][2] * (double)(Nnormal2 + Ndisease2);
        results[3][0] = tmp1[2][0];
        results[3][1] = tmp1[2][1] * (double)(Nnormal2 + Ndisease2);
        results[3][2] = tmp1[2][2] * (double)(Nnormal2 + Ndisease2);
        results[3][3] = (tmp1[0][0] + tmp1[1][0]) / 2.0 - tmp1[2][0];
        results[3][4] = ((tmp1[0][1] + tmp1[1][1]) / 2.0 - tmp1[2][1]) * (double)(Nnormal2 + Ndisease2);
        results[3][5] = ((tmp1[0][2] + tmp1[1][2]) / 2.0 - tmp1[2][2]) * (double)(Nnormal2 + Ndisease2);
        return results;
    }

    public static double[][] BDG2BCK(double[][] tempBDG, double[][] tempBCKcoeff) {
        double[][] c = new double[3][7];
        double[][] BAlpha = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, -1.0, -1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0}, {0.0, 0.0, 1.0, -1.0, 0.0, 0.0, -1.0, 1.0}, {0.0, 1.0, 0.0, -1.0, 0.0, -1.0, 0.0, 1.0}, {1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0}};
        c = Matrix.matrixTranspose(Matrix.multiply((double[][])BAlpha, Matrix.matrixTranspose(tempBDG)));
        int i = 0;
        while (i < 7) {
            if (tempBCKcoeff[2][i] == 0.0) {
                c[2][i] = 0.0;
            }
            ++i;
        }
        return c;
    }

    public static double[][] genBDGCoeff(long Nreader2, long Nnormal2, long Ndisease2) {
        double[][] c = new double[4][8];
        double[] ones = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        c[0][0] = 1.0 / (double)(Nreader2 * Nnormal2 * Ndisease2);
        c[0][1] = c[0][0] * ((double)Nnormal2 - 1.0);
        c[0][2] = c[0][0] * ((double)Ndisease2 - 1.0);
        c[0][3] = c[0][0] * ((double)Nnormal2 - 1.0) * ((double)Ndisease2 - 1.0);
        c[0][4] = c[0][0] * ((double)Nreader2 - 1.0);
        c[0][5] = c[0][0] * ((double)Nnormal2 - 1.0) * ((double)Nreader2 - 1.0);
        c[0][6] = c[0][0] * ((double)Ndisease2 - 1.0) * ((double)Nreader2 - 1.0);
        c[0][7] = c[0][0] * ((double)Ndisease2 - 1.0) * ((double)Nnormal2 - 1.0) * ((double)Nreader2 - 1.0);
        c[0][7] = c[0][7] - 1.0;
        c[1] = c[0];
        c[2] = c[0];
        c[3] = ones;
        return c;
    }

    public static double[][] genBDGSplitUnpairedCoeff(long NreaderWhole, long Nnormal2Whole, long Ndisease2Whole, int Ngroup, int Preader, int Pnormal, int Pdisease) {
        double[][] c = new double[4][8];
        double[] ones = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        long Nreader2 = NreaderWhole / (long)Ngroup / (long)(2 - Preader);
        long Nnormal2 = Nnormal2Whole / (long)Ngroup / (long)(2 - Pnormal);
        long Ndisease2 = Ndisease2Whole / (long)Ngroup / (long)(2 - Pdisease);
        double Nm = Nreader2 * Nnormal2 * Ndisease2 * (long)Ngroup;
        c[0][0] = 1.0 / Nm;
        c[0][1] = ((double)Nnormal2 - 1.0) / Nm;
        c[0][2] = ((double)Ndisease2 - 1.0) / Nm;
        c[0][3] = ((double)Nnormal2 - 1.0) * ((double)Ndisease2 - 1.0) / Nm;
        c[0][4] = ((double)Nreader2 - 1.0) / Nm;
        c[0][5] = ((double)Nnormal2 - 1.0) * ((double)Nreader2 - 1.0) / Nm;
        c[0][6] = ((double)Ndisease2 - 1.0) * ((double)Nreader2 - 1.0) / Nm;
        c[0][7] = (((double)Ndisease2 - 1.0) * ((double)Nnormal2 - 1.0) * ((double)Nreader2 - 1.0) + (double)(Ndisease2 * Nnormal2 * Nreader2 * (long)(Ngroup - 1))) / Nm;
        c[0][7] = c[0][7] - 1.0;
        c[1] = c[0];
        c[2][0] = 1.0 / Nm * (double)Preader * (double)Pnormal * (double)Pdisease;
        c[2][1] = (double)(Nnormal2 - (long)Pnormal) / Nm * (double)Preader * (double)Pdisease;
        c[2][2] = (double)(Ndisease2 - (long)Pdisease) / Nm * (double)Pnormal * (double)Preader;
        c[2][3] = (double)((Nnormal2 - (long)Pnormal) * (Ndisease2 - (long)Pdisease)) / Nm * (double)Preader;
        c[2][4] = (double)(Nreader2 - (long)Preader) / Nm * (double)Pnormal * (double)Pdisease;
        c[2][5] = (double)((Nnormal2 - (long)Pnormal) * (Nreader2 - (long)Preader)) / Nm * (double)Pdisease;
        c[2][6] = (double)((Ndisease2 - (long)Pdisease) * (Nreader2 - (long)Preader)) / Nm * (double)Pnormal;
        c[2][7] = (double)((Ndisease2 - (long)Pdisease) * (Nnormal2 - (long)Pnormal) * (Nreader2 - (long)Preader) + Ndisease2 * Nnormal2 * Nreader2 * (long)(Ngroup - 1)) / Nm;
        c[2][7] = c[2][7] - 1.0;
        c[3] = ones;
        return c;
    }

    public static double[][] genBCKCoeff(double[][] BDGcoeff_temp) {
        double[][] c2ca = new double[][]{{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        double[][] cAlpha = Matrix.multiply(BDGcoeff_temp, Matrix.matrixTranspose(c2ca));
        int i = 0;
        while (i < 7) {
            cAlpha[3][i] = 1.0;
            ++i;
        }
        return cAlpha;
    }

    public static double[][] genBCKCoeff(long Nreader, long Nnormal, long Ndisease) {
        double[][] cAlpha = new double[][]{{1.0 / (double)Nnormal, 1.0 / (double)Ndisease, 1.0 / (double)Nnormal / (double)Ndisease, 1.0 / (double)Nreader, 1.0 / (double)Nreader / (double)Nnormal, 1.0 / (double)Nreader / (double)Ndisease, 1.0 / (double)Nreader / (double)Nnormal / (double)Ndisease}, {1.0 / (double)Nnormal, 1.0 / (double)Ndisease, 1.0 / (double)Nnormal / (double)Ndisease, 1.0 / (double)Nreader, 1.0 / (double)Nreader / (double)Nnormal, 1.0 / (double)Nreader / (double)Ndisease, 1.0 / (double)Nreader / (double)Nnormal / (double)Ndisease}, {1.0 / (double)Nnormal, 1.0 / (double)Ndisease, 1.0 / (double)Nnormal / (double)Ndisease, 1.0 / (double)Nreader, 1.0 / (double)Nreader / (double)Nnormal, 1.0 / (double)Nreader / (double)Ndisease, 1.0 / (double)Nreader / (double)Nnormal / (double)Ndisease}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
        return cAlpha;
    }

    public static double[][] genDBMCoeff(long Nreader2, long Nnormal2, long Ndisease2) {
        double[][] c = new double[4][6];
        c[0][0] = 1.0 / (double)Nreader2;
        c[0][1] = 1.0 / (double)(Nnormal2 + Ndisease2);
        c[0][2] = 1.0 / (double)Nreader2 / (double)(Nnormal2 + Ndisease2);
        c[0][3] = 1.0 / (double)Nreader2;
        c[0][4] = 1.0 / (double)(Nnormal2 + Ndisease2);
        c[0][5] = 1.0 / (double)Nreader2 / (double)(Nnormal2 + Ndisease2);
        c[1] = c[0];
        c[2] = Matrix.scale(c[0], 0.0);
        c[3] = Matrix.scale(c[0], 2.0);
        c[0][3] = 0.0;
        c[0][4] = 0.0;
        c[0][5] = 0.0;
        c[1][3] = 0.0;
        c[1][4] = 0.0;
        c[1][5] = 0.0;
        c[3][0] = 0.0;
        c[3][1] = 0.0;
        c[3][2] = 0.0;
        return c;
    }

    public static double[][] genMSCoeff(long Nreader2, long Nnormal2, long Ndisease2) {
        double tmp;
        double[][] c = new double[4][6];
        c[0][0] = tmp = 1.0 / (double)(Nreader2 * (Nnormal2 + Ndisease2));
        c[0][1] = tmp;
        c[0][2] = 0.0;
        c[0][3] = 0.0;
        c[0][4] = -tmp;
        c[0][5] = 0.0;
        c[1] = c[0];
        c[2] = Matrix.scale(c[0], 0.0);
        c[3][0] = 0.0;
        c[3][1] = 0.0;
        c[3][2] = tmp * 2.0;
        c[3][3] = tmp * 2.0;
        c[3][4] = 0.0;
        c[3][5] = -tmp * 2.0;
        return c;
    }

    public static double[][] genORCoeff(long Nreader2, long Nnormal2, long Ndisease2) {
        double[][] c = new double[4][6];
        c[0][0] = 1.0 / (double)Nreader2;
        c[0][1] = 0.0;
        c[0][2] = 0.0;
        c[0][3] = 1.0 / (double)Nreader2 * (double)(Nreader2 - 1L);
        c[0][4] = 0.0;
        c[0][5] = 1.0 / (double)Nreader2;
        c[1] = c[0];
        c[2] = Matrix.scale(c[0], 0.0);
        c[3][0] = 0.0;
        c[3][1] = 2.0 / (double)Nreader2;
        c[3][2] = -2.0 / (double)Nreader2;
        c[3][3] = 2.0 / (double)Nreader2 * (double)(Nreader2 - 1L);
        c[3][4] = -2.0 / (double)Nreader2 * (double)(Nreader2 - 1L);
        c[3][5] = 2.0 / (double)Nreader2;
        return c;
    }

    public void BDG2OR() {
        double temp;
        double dnr = this.Nreader;
        double dn0 = this.Nnormal;
        double dn1 = this.Ndisease;
        double dnm = 2.0;
        double c1 = 1.0 / dn0 / dn1;
        double c2 = (dn0 - 1.0) / dn0 / dn1;
        double c3 = (dn1 - 1.0) / dn0 / dn1;
        double c4 = (dn0 - 1.0) * (dn1 - 1.0) / dn0 / dn1 - 1.0;
        this.ms_t = 0.0;
        this.ms_tA = 0.0;
        this.ms_tB = 0.0;
        this.ms_tr = 0.0;
        this.ms_trA = 0.0;
        this.ms_trB = 0.0;
        int i = 0;
        while (i < 2) {
            temp = this.AUCsReaderAvg[i] - (this.AUCsReaderAvg[0] + this.AUCsReaderAvg[1]) / 2.0;
            this.ms_t += Math.pow(temp, 2.0);
            int j = 0;
            while ((double)j < dnr) {
                temp = this.AUCs[j][i] - this.AUCsReaderAvg[i] - (this.AUCs[j][0] + this.AUCs[j][1]) / 2.0 + (this.AUCsReaderAvg[0] + this.AUCsReaderAvg[1]) / 2.0;
                this.ms_tr += Math.pow(temp, 2.0);
                ++j;
            }
            ++i;
        }
        this.ms_t = dnr * this.ms_t / (dnm - 1.0);
        this.ms_tr = this.ms_tr / (dnr - 1.0) / (dnm - 1.0);
        this.ms_r = 0.0;
        this.ms_rA = 0.0;
        this.ms_rB = 0.0;
        int j = 0;
        while ((double)j < dnr) {
            temp = this.AUCs[j][0] - this.AUCsReaderAvg[0];
            this.ms_rA += Math.pow(temp, 2.0);
            temp = this.AUCs[j][1] - this.AUCsReaderAvg[1];
            this.ms_rB += Math.pow(temp, 2.0);
            temp = (this.AUCs[j][0] + this.AUCs[j][1]) / 2.0 - (this.AUCsReaderAvg[0] + this.AUCsReaderAvg[1]) / 2.0;
            this.ms_r += Math.pow(temp, 2.0);
            ++j;
        }
        this.ms_rA /= dnr - 1.0;
        this.ms_rB /= dnr - 1.0;
        this.ms_r = dnm * this.ms_r / (dnr - 1.0);
        double errorA = c1 * this.BDG[0][0] + c2 * this.BDG[0][1] + c3 * this.BDG[0][2] + c4 * this.BDG[0][3];
        double cov1A = 0.0;
        double cov2A = c1 * this.BDG[0][4] + c2 * this.BDG[0][5] + c3 * this.BDG[0][6] + c4 * this.BDG[0][7];
        double cov3A = 0.0;
        double errorB = c1 * this.BDG[1][0] + c2 * this.BDG[1][1] + c3 * this.BDG[1][2] + c4 * this.BDG[1][3];
        double cov1B = 0.0;
        double cov2B = c1 * this.BDG[1][4] + c2 * this.BDG[1][5] + c3 * this.BDG[1][6] + c4 * this.BDG[1][7];
        double cov3B = 0.0;
        double error = (errorA + errorB) / 2.0;
        double cov1 = c1 * this.BDG[2][0] + c2 * this.BDG[2][1] + c3 * this.BDG[2][2] + c4 * this.BDG[2][3];
        double cov2 = (cov2A + cov2B) / 2.0;
        double cov3 = c1 * this.BDG[2][4] + c2 * this.BDG[2][5] + c3 * this.BDG[2][6] + c4 * this.BDG[2][7];
        double var_rA = this.ms_rA + cov2A - errorA;
        double var_mrA = this.ms_trA;
        this.OR[0][0] = var_rA;
        this.OR[0][1] = var_mrA;
        this.OR[0][2] = cov1A;
        this.OR[0][3] = cov2A;
        this.OR[0][4] = cov3A;
        this.OR[0][5] = errorA;
        double var_rB = this.ms_rB + cov2B - errorB;
        double var_mrB = this.ms_trB;
        this.OR[1][0] = var_rB;
        this.OR[1][1] = var_mrB;
        this.OR[1][2] = cov1B;
        this.OR[1][3] = cov2B;
        this.OR[1][4] = cov3B;
        this.OR[1][5] = errorB;
        double var_r = (this.ms_r - this.ms_tr) / 2.0 - cov1 + cov3;
        double var_mr = this.ms_tr - error + cov1 + (cov2 - cov3);
        this.OR[3][0] = var_r;
        this.OR[3][1] = var_mr;
        this.OR[3][2] = cov1;
        this.OR[3][3] = cov2;
        this.OR[3][4] = cov3;
        this.OR[3][5] = error;
        var_rA = this.DBM[0][0];
        var_mrA = 0.0;
        cov1A = 0.0;
        cov2A = this.DBM[0][1] / (dn0 + dn1);
        cov3A = 0.0;
        errorA = (this.DBM[0][1] + this.DBM[0][2]) / (dn0 + dn1);
        var_rB = this.DBM[1][0];
        var_mrB = 0.0;
        cov1B = 0.0;
        cov2B = this.DBM[1][1] / (dn0 + dn1);
        cov3B = 0.0;
        errorB = (this.DBM[1][1] + this.DBM[1][2]) / (dn0 + dn1);
        var_r = this.DBM[3][0];
        var_mr = this.DBM[3][3];
        cov1 = (this.DBM[3][1] + this.DBM[3][2]) / (dn0 + dn1);
        cov2 = (this.DBM[3][1] + this.DBM[3][4]) / (dn0 + dn1);
        cov3 = this.DBM[3][1] / (dn0 + dn1);
        error = (this.DBM[3][1] + this.DBM[3][2] + this.DBM[3][4] + this.DBM[3][5]) / (dn0 + dn1);
    }

    public static double[][] DBM2OR(int index, double[][] in, long Nreader2, long Nnormal2, long Ndisease2) {
        double[][] toReturn = new double[4][6];
        double[][] dbm = new double[4][6];
        double[][] orVar = new double[4][6];
        if (index == 0) {
            dbm = in;
            int i = 0;
            while (i < 4) {
                orVar[i][0] = dbm[i][0];
                orVar[i][1] = dbm[i][3];
                orVar[i][2] = (dbm[i][1] + dbm[i][2]) / (double)(Nnormal2 + Ndisease2);
                orVar[i][3] = (dbm[i][1] + dbm[i][4]) / (double)(Nnormal2 + Ndisease2);
                orVar[i][4] = dbm[i][1] / (double)(Nnormal2 + Ndisease2);
                orVar[i][5] = (dbm[i][1] + dbm[i][2] + dbm[i][4] + dbm[i][5]) / (double)(Nnormal2 + Ndisease2);
                ++i;
            }
            toReturn = orVar;
        } else {
            orVar = in;
            int i = 0;
            while (i < 4) {
                dbm[i][0] = orVar[i][0];
                dbm[i][1] = orVar[i][4] * (double)(Nnormal2 + Ndisease2);
                dbm[i][2] = (orVar[i][2] - orVar[i][4]) * (double)(Nnormal2 + Ndisease2);
                dbm[i][3] = orVar[i][1];
                dbm[i][4] = (orVar[i][3] - orVar[i][4]) * (double)(Nnormal2 + Ndisease2);
                dbm[i][5] = (orVar[i][5] - orVar[i][2] - orVar[i][3] + orVar[i][4]) * (double)(Nnormal2 + Ndisease2);
                ++i;
            }
            toReturn = dbm;
        }
        return toReturn;
    }

    public double[][] BCKresize(double[][] bck, int newR, int newN, int newD) {
        return bck;
    }

    public double[][] DBMresize(double[][] dbm, int newR, int newN, int newD) {
        double[][] DBMnew = new double[4][6];
        double lamda = 1.0 / Double.valueOf(newN + newD);
        int i = 0;
        while (i < 4) {
            DBMnew[i][0] = dbm[i][0];
            DBMnew[i][1] = dbm[i][1] * lamda;
            DBMnew[i][2] = dbm[i][2] * lamda;
            DBMnew[i][3] = dbm[i][3];
            DBMnew[i][4] = dbm[i][4] * lamda;
            DBMnew[i][5] = dbm[i][5] * lamda;
            ++i;
        }
        return DBMnew;
    }

    public static void copy(DBRecord DBRecordTemp, DBRecord copyDBRecordTemp) {
        copyDBRecordTemp.AUCs = Matrix.copy(DBRecordTemp.AUCs);
        copyDBRecordTemp.AUCsReaderAvg = Matrix.copy(DBRecordTemp.AUCsReaderAvg);
        copyDBRecordTemp.BDG = Matrix.copy(DBRecordTemp.BDG);
        copyDBRecordTemp.BDGbias = Matrix.copy(DBRecordTemp.BDGbias);
        copyDBRecordTemp.BDGcoeff = Matrix.copy(DBRecordTemp.BDGcoeff);
        copyDBRecordTemp.testStat.ciBotNormal = DBRecordTemp.testStat.ciBotNormal;
        copyDBRecordTemp.testStat.ciBotBDG = DBRecordTemp.testStat.ciBotBDG;
        copyDBRecordTemp.testStat.ciBotHillis = DBRecordTemp.testStat.ciBotHillis;
        copyDBRecordTemp.testStat.ciTopNormal = DBRecordTemp.testStat.ciTopNormal;
        copyDBRecordTemp.testStat.ciTopBDG = DBRecordTemp.testStat.ciTopBDG;
        copyDBRecordTemp.testStat.ciTopHillis = DBRecordTemp.testStat.ciTopHillis;
        copyDBRecordTemp.testStat.cutoffNormal = DBRecordTemp.testStat.cutoffNormal;
        copyDBRecordTemp.testStat.cutoffBDG = DBRecordTemp.testStat.cutoffBDG;
        copyDBRecordTemp.testStat.cutoffHillis = DBRecordTemp.testStat.cutoffHillis;
        copyDBRecordTemp.testStat.DF_BDG = DBRecordTemp.testStat.DF_BDG;
        copyDBRecordTemp.testStat.DF_Hillis = DBRecordTemp.testStat.DF_Hillis;
        copyDBRecordTemp.testStat.pValNormal = DBRecordTemp.testStat.pValNormal;
        copyDBRecordTemp.testStat.pValBDG = DBRecordTemp.testStat.pValBDG;
        copyDBRecordTemp.testStat.pValHillis = DBRecordTemp.testStat.pValHillis;
        copyDBRecordTemp.testStat.tStatEst = DBRecordTemp.testStat.tStatEst;
        copyDBRecordTemp.testStat.rejectNormal = DBRecordTemp.testStat.rejectNormal;
        copyDBRecordTemp.testStat.rejectBDG = DBRecordTemp.testStat.rejectBDG;
        copyDBRecordTemp.testStat.rejectHillis = DBRecordTemp.testStat.rejectHillis;
        copyDBRecordTemp.totalVar = DBRecordTemp.totalVar;
        copyDBRecordTemp.SE = DBRecordTemp.SE;
        copyDBRecordTemp.varA = DBRecordTemp.varA;
        copyDBRecordTemp.varB = DBRecordTemp.varB;
        copyDBRecordTemp.readerVarA = Matrix.copy(DBRecordTemp.readerVarA);
        copyDBRecordTemp.readerVarB = Matrix.copy(DBRecordTemp.readerVarB);
        copyDBRecordTemp.readerTotalVar = Matrix.copy(DBRecordTemp.readerTotalVar);
        copyDBRecordTemp.flagTotalVarIsNegative = DBRecordTemp.flagTotalVarIsNegative;
    }

    public static void add(DBRecord DBRecordTemp, DBRecord sumDBRecordTemp) {
        sumDBRecordTemp.AUCs = Matrix.add(sumDBRecordTemp.AUCs, DBRecordTemp.AUCs);
        sumDBRecordTemp.AUCsReaderAvg = Matrix.add(sumDBRecordTemp.AUCsReaderAvg, DBRecordTemp.AUCsReaderAvg);
        sumDBRecordTemp.BDG = Matrix.add(sumDBRecordTemp.BDG, DBRecordTemp.BDG);
        sumDBRecordTemp.BDGbias = Matrix.add(sumDBRecordTemp.BDGbias, DBRecordTemp.BDGbias);
        sumDBRecordTemp.BDGcoeff = Matrix.add(sumDBRecordTemp.BDGcoeff, DBRecordTemp.BDGcoeff);
        sumDBRecordTemp.testStat.ciBotNormal += DBRecordTemp.testStat.ciBotNormal;
        sumDBRecordTemp.testStat.ciBotBDG += DBRecordTemp.testStat.ciBotBDG;
        sumDBRecordTemp.testStat.ciBotHillis += DBRecordTemp.testStat.ciBotHillis;
        sumDBRecordTemp.testStat.ciTopNormal += DBRecordTemp.testStat.ciTopNormal;
        sumDBRecordTemp.testStat.ciTopBDG += DBRecordTemp.testStat.ciTopBDG;
        sumDBRecordTemp.testStat.ciTopHillis += DBRecordTemp.testStat.ciTopHillis;
        sumDBRecordTemp.testStat.cutoffNormal += DBRecordTemp.testStat.cutoffNormal;
        sumDBRecordTemp.testStat.cutoffBDG += DBRecordTemp.testStat.cutoffBDG;
        sumDBRecordTemp.testStat.cutoffHillis += DBRecordTemp.testStat.cutoffHillis;
        sumDBRecordTemp.testStat.DF_BDG += DBRecordTemp.testStat.DF_BDG;
        sumDBRecordTemp.testStat.DF_Hillis += DBRecordTemp.testStat.DF_Hillis;
        sumDBRecordTemp.testStat.pValNormal += DBRecordTemp.testStat.pValNormal;
        sumDBRecordTemp.testStat.pValBDG += DBRecordTemp.testStat.pValBDG;
        sumDBRecordTemp.testStat.pValHillis += DBRecordTemp.testStat.pValHillis;
        sumDBRecordTemp.testStat.tStatEst += DBRecordTemp.testStat.tStatEst;
        sumDBRecordTemp.testStat.rejectNormal += DBRecordTemp.testStat.rejectNormal;
        sumDBRecordTemp.testStat.rejectBDG += DBRecordTemp.testStat.rejectBDG;
        sumDBRecordTemp.testStat.rejectHillis += DBRecordTemp.testStat.rejectHillis;
        sumDBRecordTemp.totalVar += DBRecordTemp.totalVar;
        sumDBRecordTemp.SE += DBRecordTemp.SE;
        sumDBRecordTemp.varA += DBRecordTemp.varA;
        sumDBRecordTemp.varB += DBRecordTemp.varB;
        sumDBRecordTemp.readerVarA = Matrix.add(sumDBRecordTemp.readerVarA, DBRecordTemp.readerVarA);
        sumDBRecordTemp.readerVarB = Matrix.add(sumDBRecordTemp.readerVarB, DBRecordTemp.readerVarB);
        sumDBRecordTemp.readerTotalVar = Matrix.add(sumDBRecordTemp.readerTotalVar, DBRecordTemp.readerTotalVar);
        sumDBRecordTemp.flagTotalVarIsNegative += DBRecordTemp.flagTotalVarIsNegative;
    }

    public static void scale(DBRecord DBRecordTemp, double scaleFactor) {
        DBRecordTemp.AUCs = Matrix.scale(DBRecordTemp.AUCs, scaleFactor);
        DBRecordTemp.AUCsReaderAvg = Matrix.scale(DBRecordTemp.AUCsReaderAvg, scaleFactor);
        DBRecordTemp.BDG = Matrix.scale(DBRecordTemp.BDG, scaleFactor);
        DBRecordTemp.BDGbias = Matrix.scale(DBRecordTemp.BDGbias, scaleFactor);
        DBRecordTemp.BDGcoeff = Matrix.scale(DBRecordTemp.BDGcoeff, scaleFactor);
        DBRecordTemp.testStat.ciBotNormal *= scaleFactor;
        DBRecordTemp.testStat.ciBotBDG *= scaleFactor;
        DBRecordTemp.testStat.ciBotHillis *= scaleFactor;
        DBRecordTemp.testStat.ciTopNormal *= scaleFactor;
        DBRecordTemp.testStat.ciTopBDG *= scaleFactor;
        DBRecordTemp.testStat.ciTopHillis *= scaleFactor;
        DBRecordTemp.testStat.cutoffNormal *= scaleFactor;
        DBRecordTemp.testStat.cutoffBDG *= scaleFactor;
        DBRecordTemp.testStat.cutoffHillis *= scaleFactor;
        DBRecordTemp.testStat.DF_BDG *= scaleFactor;
        DBRecordTemp.testStat.DF_Hillis *= scaleFactor;
        DBRecordTemp.testStat.pValNormal *= scaleFactor;
        DBRecordTemp.testStat.pValBDG *= scaleFactor;
        DBRecordTemp.testStat.pValHillis *= scaleFactor;
        DBRecordTemp.testStat.tStatEst *= scaleFactor;
        DBRecordTemp.testStat.rejectNormal *= scaleFactor;
        DBRecordTemp.testStat.rejectBDG *= scaleFactor;
        DBRecordTemp.testStat.rejectHillis *= scaleFactor;
        DBRecordTemp.totalVar *= scaleFactor;
        DBRecordTemp.SE *= scaleFactor;
        DBRecordTemp.varA *= scaleFactor;
        DBRecordTemp.varB *= scaleFactor;
        DBRecordTemp.readerVarA = Matrix.scale(DBRecordTemp.readerVarA, scaleFactor);
        DBRecordTemp.readerVarB = Matrix.scale(DBRecordTemp.readerVarB, scaleFactor);
        DBRecordTemp.readerTotalVar = Matrix.scale(DBRecordTemp.readerTotalVar, scaleFactor);
        DBRecordTemp.flagTotalVarIsNegative = (long)((double)DBRecordTemp.flagTotalVarIsNegative * scaleFactor);
    }

    public static void square(DBRecord DBRecordTemp) {
        DBRecordTemp.AUCs = Matrix.squareTerms(DBRecordTemp.AUCs);
        DBRecordTemp.AUCsReaderAvg = Matrix.squareTerms(DBRecordTemp.AUCsReaderAvg);
        DBRecordTemp.BDG = Matrix.squareTerms(DBRecordTemp.BDG);
        DBRecordTemp.BDGbias = Matrix.squareTerms(DBRecordTemp.BDGbias);
        DBRecordTemp.BDGcoeff = Matrix.squareTerms(DBRecordTemp.BDGcoeff);
        DBRecordTemp.testStat.ciBotNormal *= DBRecordTemp.testStat.ciBotNormal;
        DBRecordTemp.testStat.ciBotBDG *= DBRecordTemp.testStat.ciBotBDG;
        DBRecordTemp.testStat.ciBotHillis *= DBRecordTemp.testStat.ciBotHillis;
        DBRecordTemp.testStat.ciTopNormal *= DBRecordTemp.testStat.ciTopNormal;
        DBRecordTemp.testStat.ciTopBDG *= DBRecordTemp.testStat.ciTopBDG;
        DBRecordTemp.testStat.ciTopHillis *= DBRecordTemp.testStat.ciTopHillis;
        DBRecordTemp.testStat.cutoffNormal *= DBRecordTemp.testStat.cutoffNormal;
        DBRecordTemp.testStat.cutoffBDG *= DBRecordTemp.testStat.cutoffBDG;
        DBRecordTemp.testStat.cutoffHillis *= DBRecordTemp.testStat.cutoffHillis;
        DBRecordTemp.testStat.DF_BDG *= DBRecordTemp.testStat.DF_BDG;
        DBRecordTemp.testStat.DF_Hillis *= DBRecordTemp.testStat.DF_Hillis;
        DBRecordTemp.testStat.pValNormal *= DBRecordTemp.testStat.pValNormal;
        DBRecordTemp.testStat.pValBDG *= DBRecordTemp.testStat.pValBDG;
        DBRecordTemp.testStat.pValHillis *= DBRecordTemp.testStat.pValHillis;
        DBRecordTemp.testStat.tStatEst *= DBRecordTemp.testStat.tStatEst;
        DBRecordTemp.testStat.rejectNormal *= DBRecordTemp.testStat.rejectNormal;
        DBRecordTemp.testStat.rejectBDG *= DBRecordTemp.testStat.rejectBDG;
        DBRecordTemp.testStat.rejectHillis *= DBRecordTemp.testStat.rejectHillis;
        DBRecordTemp.totalVar *= DBRecordTemp.totalVar;
        DBRecordTemp.SE *= DBRecordTemp.SE;
        DBRecordTemp.varA *= DBRecordTemp.varA;
        DBRecordTemp.varB *= DBRecordTemp.varB;
        DBRecordTemp.readerVarA = Matrix.squareTerms(DBRecordTemp.readerVarA);
        DBRecordTemp.readerVarB = Matrix.squareTerms(DBRecordTemp.readerVarB);
        DBRecordTemp.readerTotalVar = Matrix.squareTerms(DBRecordTemp.readerTotalVar);
        DBRecordTemp.flagTotalVarIsNegative *= DBRecordTemp.flagTotalVarIsNegative;
    }
}

