% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure.joint.prob.R
\name{figure.joint.prob}
\alias{figure.joint.prob}
\title{Contour Plot of Joint Probabilities related to Mediated Effect}
\usage{
figure.joint.prob(prob = "mediated.main", n = 100, sig.level = 0.05,
  grid.size = 0.01)
}
\arguments{
\item{prob}{a character string specifying the probability to be plotted. One
of \code{"mediated.main"} (default) and \code{"mediated.direct"}.
\code{"mediated.main"} requests the probability of the mediated effect and
the main effect assuming there is no direct effect (\eqn{c'=0}).
\code{"mediated.direct"} requests the probability of the mediated effect and
the direct effect assuming \eqn{ab=c'}}

\item{n}{sample size}

\item{sig.level}{significance level used for the test of the mediated effect}

\item{grid.size}{grid size for \eqn{a^2} and \eqn{b^2}}
}
\value{
A plot generated using package \code{plotly}
}
\description{
Contour plot of joint probability of mediated effect and total effect in the
absence of direct effect and joint probability of mediated effect and direct
effect assuming \eqn{ab=c'}
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
Basic three-factor mediation model is assumed. Coefficients are standardized such
that the variances of treatment, mediator, and outcome are equal to 1. Note
that the y-axis is \eqn{a^2} and the x-axis is \eqn{b^2}. The default axes
labels from R function \code{plot_ly} are switched in order to make them
correct.
}
\examples{

figure.joint.prob()                                # Figure 4 of Wang (2018)
figure.joint.prob(prob="mediated.direct")          # Figure 5 of Wang (2018)

}
\references{
Wang, K. (2018) Understanding power anomalies in mediation
analysis. Psychometrika 83 (2), 387-406.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{figure}
