% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoEntropy}
\alias{ChaoEntropy}
\title{Estimation of Shannon entropy}
\usage{
ChaoEntropy(x, datatype = "abundance", transform = FALSE, conf = 0.95,
  B = 200)
}
\arguments{
\item{x}{a vector of species frequence}

\item{datatype}{the data type of input data. That is individual-based abundance data (\code{datatype = "abundance"}) or sample-based incidence data (\code{datatype = "incidence"}).}

\item{transform}{a \code{logical} constant to compute traditional index or the effective transformation. Default is \code{logical=FALSE}.}

\item{conf}{a positive number \eqn{\le} 1. "\code{conf}" specifies the confidence level for confidence interval. The default is \code{0.95}.}

\item{B}{the number of bootstrap resampling times, default is \code{200}.}
}
\value{
a value of species richness estimator
}
\description{
\code{ChaoEntropy} Estimation of Shannon entropy via Chao et al. (2013)
}
\examples{
data(spider)
ChaoSpecies(spider$Girdled, datatype="abundance")
}
\author{
Y.H. Lee
}
\seealso{
\code{\link{ChaoSpecies}}
}

